import { defineComponent, openBlock, createElementBlock, normalizeClass, unref, toDisplayString, createCommentVNode, renderSlot, createElementVNode } from 'vue';
import '../../../hooks/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpGroupContainer"
  },
  __name: "groupContainer",
  props: {
    title: { type: String, required: false, default: "" },
    isBorder: { type: Boolean, required: false, default: false }
  },
  setup(__props) {
    const bem = useNamespace("group");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass([unref(bem).e("container"), { "is-border": __props.isBorder }])
        },
        [
          __props.title || _ctx.$slots.toolbar ? (openBlock(), createElementBlock(
            "div",
            {
              key: 0,
              class: normalizeClass(unref(bem).e("header"))
            },
            [
              __props.title ? (openBlock(), createElementBlock(
                "div",
                {
                  key: 0,
                  class: normalizeClass(unref(bem).e("title"))
                },
                toDisplayString(__props.title),
                3
                /* TEXT, CLASS */
              )) : createCommentVNode("v-if", true),
              _ctx.$slots.toolbar ? (openBlock(), createElementBlock(
                "div",
                {
                  key: 1,
                  class: normalizeClass(unref(bem).e("toolbar"))
                },
                [
                  renderSlot(_ctx.$slots, "toolbar")
                ],
                2
                /* CLASS */
              )) : createCommentVNode("v-if", true)
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true),
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(bem).e("content"))
            },
            [
              renderSlot(_ctx.$slots, "content")
            ],
            2
            /* CLASS */
          )
        ],
        2
        /* CLASS */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=groupContainer.vue2.mjs.map
