import { defineComponent, computed, openBlock, createElementBlock, normalizeClass, unref, createVNode, withCtx, createBlock, createCommentVNode } from 'vue';
import '../../../hooks/index.mjs';
import { ElRow, ElCol } from 'element-plus';
import './buttonGroup.vue.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import _sfc_main$1 from './buttonGroup.vue2.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpTableToolbar"
  },
  __name: "tableToolbar",
  props: {
    actions: { type: Array, required: false, default: () => [] },
    moreButtonText: { type: String, required: false, default: "\u66F4\u591A" },
    primaryColSpan: { type: Number, required: false },
    secondaryColSpan: { type: Number, required: false },
    rows: { type: Array, required: false, default: () => [] },
    space: { type: Number, required: false, default: 12 }
  },
  emits: ["on-command"],
  setup(__props, { emit: __emit }) {
    const bem = useNamespace("table");
    const props = __props;
    const emit = __emit;
    const onCommand = (command, rows) => {
      emit("on-command", command, rows);
    };
    const primaryActions = computed(() => {
      return props.actions.filter(
        (item) => item.position == "left" || !item.position
      );
    });
    const secondaryActions = computed(() => {
      return props.actions.filter((item) => item.position == "right");
    });
    const primaryColSpan = computed(() => {
      if (props.primaryColSpan != void 0) {
        return props.primaryColSpan;
      } else {
        if (primaryActions.value.length > 0) {
          return 16;
        } else {
          return 0;
        }
      }
    });
    const secondaryColSpan = computed(() => {
      if (props.secondaryColSpan != void 0) {
        return props.secondaryColSpan;
      } else {
        if (secondaryActions.value.length > 0) {
          return 8;
        } else {
          return 0;
        }
      }
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(bem).e("toolbar"))
        },
        [
          createVNode(unref(ElRow), null, {
            default: withCtx(() => [
              primaryActions.value.length > 0 ? (openBlock(), createBlock(unref(ElCol), {
                key: 0,
                span: primaryColSpan.value
              }, {
                default: withCtx(() => [
                  createVNode(_sfc_main$1, {
                    actions: primaryActions.value,
                    moreButtonText: __props.moreButtonText,
                    rows: __props.rows,
                    buttonType: "primary",
                    space: __props.space,
                    plain: false,
                    onCommand
                  }, null, 8, ["actions", "moreButtonText", "rows", "space"])
                ]),
                _: 1
                /* STABLE */
              }, 8, ["span"])) : createCommentVNode("v-if", true),
              secondaryActions.value.length > 0 ? (openBlock(), createBlock(unref(ElCol), {
                key: 1,
                span: secondaryColSpan.value
              }, {
                default: withCtx(() => [
                  createVNode(_sfc_main$1, {
                    style: { "text-align": "right" },
                    actions: secondaryActions.value,
                    moreButtonText: __props.moreButtonText,
                    buttonType: "primary",
                    space: __props.space,
                    plain: true,
                    onCommand,
                    rows: __props.rows
                  }, null, 8, ["actions", "moreButtonText", "space", "rows"])
                ]),
                _: 1
                /* STABLE */
              }, 8, ["span"])) : createCommentVNode("v-if", true)
            ]),
            _: 1
            /* STABLE */
          })
        ],
        2
        /* CLASS */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=tableToolbar.vue2.mjs.map
