'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var lodashEs = require('lodash-es');
require('../../../hooks/index.js');
require('../../../utils/index.js');
var elementPlus = require('element-plus');
var index$1 = require('../../../../svg-icons/vue/dist/index.js');
var index = require('../../../hooks/use-namespace/index.js');
var istype = require('../../../utils/tools/istype.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpButtonGroup"
  },
  __name: "buttonGroup",
  props: {
    actions: { type: Array, required: true, default: () => [] },
    moreButtonText: { type: String, required: false, default: "\u66F4\u591A" },
    buttonType: { required: false, default: "primary" },
    plain: { type: Boolean, required: false, default: false },
    space: { type: Number, required: false, default: 12 },
    rows: { type: Array, required: false, default: () => [] }
  },
  emits: ["command"],
  setup(__props, { emit: __emit }) {
    const bem = index.useNamespace("button");
    const props = __props;
    const emit = __emit;
    const pCur = vue.ref(-1);
    const visibleButtons = vue.computed(() => {
      if (pCur.value > 0) {
        return props.actions.slice(0, pCur.value);
      } else {
        return props.actions;
      }
    });
    const moreButtons = vue.computed(() => {
      if (pCur.value > 0) {
        let temp = [];
        let res = props.actions.slice(pCur.value);
        for (let i = 0; i < res.length; i++) {
          if (res[i].children != void 0 && res[i].children.length > 0) {
            temp.push(...res[i].children);
          } else {
            temp.push(res[i]);
          }
        }
        return temp;
      } else {
        return [];
      }
    });
    const popperOptions = {
      modifiers: [
        {
          name: "offset",
          options: {
            offset: [0, 7]
            // 水平偏移0，垂直偏移10像素
          }
        }
      ]
    };
    let resizeObsever;
    const groupHeight = vue.ref(28);
    const groupRef = vue.ref(null);
    let btnSizes = [];
    function getButtonSize() {
      let group = groupRef == null ? void 0 : groupRef.value;
      let space = props.space;
      if (!group) return;
      if (btnSizes.length > 0) {
        btnSizes = [];
      }
      let buttons = group.querySelectorAll(".el-button");
      if (buttons && buttons.length > 0) {
        groupHeight.value = buttons[0].offsetHeight;
        let left = 0;
        for (let i = 0; i < buttons.length; i++) {
          left += buttons[i].offsetWidth + space;
          btnSizes.push(left);
        }
      }
    }
    function getContainerWidth() {
      let group = groupRef == null ? void 0 : groupRef.value;
      if (!group) return null;
      return group.offsetWidth;
    }
    function reBuild() {
      let width = getContainerWidth();
      if (width) {
        let cur = -1;
        for (let i = 0; i < btnSizes.length; i++) {
          if (btnSizes[i] - width > props.space) {
            cur = i - 1;
            break;
          }
          cur = -1;
        }
        pCur.value = cur;
      }
    }
    function modeChangeResize() {
      var _a;
      (_a = groupRef.value) == null ? void 0 : _a.addEventListener(
        "transitionend",
        () => {
          pCur.value = -1;
          vue.nextTick(() => {
            getButtonSize();
            reBuild();
          });
        },
        { once: true }
      );
    }
    function getConfirmText(confirm) {
      if (istype.isString(confirm)) {
        return confirm;
      }
      return "\u60A8\u786E\u5B9A\u8BE5\u64CD\u4F5C\uFF1F";
    }
    function getActionEnabled(action) {
      if (action.disabled) return false;
      if (!action.limit || action.limit === "none") {
        return true;
      }
      if (action.limit === "one" && props.rows.length === 1) {
        return true;
      }
      if (action.limit === "more" && props.rows.length > 0) {
        return true;
      }
      return false;
    }
    function onConfirmAction(action) {
      if (action.confirm) {
        elementPlus.ElMessageBox.confirm(getConfirmText(action.confirm), "\u63D0\u793A", {
          type: "warning",
          cancelButtonText: "\u53D6\u6D88",
          confirmButtonText: "\u786E\u5B9A"
        }).then(() => {
          onAction(action);
        }).catch(() => {
        });
      } else {
        onAction(action);
      }
    }
    function onAction(action) {
      const rows = action.limit === "one" ? props.rows[0] : props.rows;
      if (action.onclick) {
        if (istype.isFunction(action.onclick)) {
          action.onclick(rows);
        } else {
          emit("command", action.onclick, rows);
        }
      }
    }
    const reCalcBtnSize = lodashEs.debounce(function() {
      if (groupHeight.value > 0) {
        return;
      }
      getButtonSize();
    }, 100);
    vue.onMounted(() => {
      vue.nextTick(() => {
        requestAnimationFrame(() => {
          getButtonSize();
          reBuild();
        });
      });
      if ((groupRef == null ? void 0 : groupRef.value) && ResizeObserver) {
        resizeObsever = new ResizeObserver(reCalcBtnSize);
        resizeObsever.observe(groupRef == null ? void 0 : groupRef.value);
      }
      window.addEventListener("resize", reBuild);
      window.addEventListener("modeChange", modeChangeResize);
    });
    vue.onBeforeUnmount(() => {
      window.removeEventListener("resize", reBuild);
      window.removeEventListener("modeChange", modeChangeResize);
      resizeObsever == null ? void 0 : resizeObsever.disconnect();
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock(
        "div",
        {
          class: vue.normalizeClass(vue.unref(bem).e("group")),
          ref_key: "groupRef",
          ref: groupRef,
          style: vue.normalizeStyle({ height: groupHeight.value + "px" })
        },
        [
          (vue.openBlock(true), vue.createElementBlock(
            vue.Fragment,
            null,
            vue.renderList(visibleButtons.value, (item) => {
              return vue.openBlock(), vue.createElementBlock(
                vue.Fragment,
                {
                  key: item.key
                },
                [
                  item.children != null && item.children.length > 0 ? (vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElDropdown), {
                    key: 0,
                    "popper-options": popperOptions,
                    "popper-class": vue.unref(bem).em("group", "popper"),
                    "max-heighgt": "280px",
                    placement: "bottom-start"
                  }, {
                    dropdown: vue.withCtx(() => [
                      vue.createVNode(
                        vue.unref(elementPlus.ElDropdownMenu),
                        null,
                        {
                          default: vue.withCtx(() => [
                            (vue.openBlock(true), vue.createElementBlock(
                              vue.Fragment,
                              null,
                              vue.renderList(item.children, (child, index) => {
                                return vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElDropdownItem), {
                                  key: index,
                                  disabled: !getActionEnabled(child),
                                  icon: child.icon,
                                  onClick: ($event) => onConfirmAction(child)
                                }, {
                                  default: vue.withCtx(() => [
                                    vue.createTextVNode(
                                      vue.toDisplayString(child.text),
                                      1
                                      /* TEXT */
                                    )
                                  ]),
                                  _: 2
                                  /* DYNAMIC */
                                }, 1032, ["disabled", "icon", "onClick"]);
                              }),
                              128
                              /* KEYED_FRAGMENT */
                            ))
                          ]),
                          _: 2
                          /* DYNAMIC */
                        },
                        1024
                        /* DYNAMIC_SLOTS */
                      )
                    ]),
                    default: vue.withCtx(() => [
                      vue.createVNode(vue.unref(elementPlus.ElButton), {
                        icon: item.icon,
                        disabled: !getActionEnabled(item),
                        type: item.type,
                        plain: item.plain,
                        title: item.tooltip
                      }, {
                        default: vue.withCtx(() => [
                          item.text ? (vue.openBlock(), vue.createElementBlock(
                            vue.Fragment,
                            { key: 0 },
                            [
                              vue.createTextVNode(
                                vue.toDisplayString(item.text),
                                1
                                /* TEXT */
                              )
                            ],
                            64
                            /* STABLE_FRAGMENT */
                          )) : vue.createCommentVNode("v-if", true),
                          vue.createVNode(vue.unref(elementPlus.ElIcon), { class: "el-icon--right" }, {
                            default: vue.withCtx(() => [
                              vue.createVNode(vue.unref(index$1.ArrowDown))
                            ]),
                            _: 1
                            /* STABLE */
                          })
                        ]),
                        _: 2
                        /* DYNAMIC */
                      }, 1032, ["icon", "disabled", "type", "plain", "title"])
                    ]),
                    _: 2
                    /* DYNAMIC */
                  }, 1032, ["popper-class"])) : (vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElButton), {
                    key: 1,
                    icon: item.icon,
                    disabled: !getActionEnabled(item),
                    type: item.type,
                    plain: item.plain,
                    title: item.tooltip,
                    onClick: ($event) => onConfirmAction(item)
                  }, {
                    default: vue.withCtx(() => [
                      item.text ? (vue.openBlock(), vue.createElementBlock(
                        vue.Fragment,
                        { key: 0 },
                        [
                          vue.createTextVNode(
                            vue.toDisplayString(item.text),
                            1
                            /* TEXT */
                          )
                        ],
                        64
                        /* STABLE_FRAGMENT */
                      )) : vue.createCommentVNode("v-if", true)
                    ]),
                    _: 2
                    /* DYNAMIC */
                  }, 1032, ["icon", "disabled", "type", "plain", "title", "onClick"]))
                ],
                64
                /* STABLE_FRAGMENT */
              );
            }),
            128
            /* KEYED_FRAGMENT */
          )),
          moreButtons.value.length > 0 ? (vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElDropdown), {
            key: 0,
            "popper-options": popperOptions,
            "popper-class": vue.unref(bem).em("group", "popper"),
            "max-heighgt": "280px",
            placement: "bottom-start"
          }, {
            dropdown: vue.withCtx(() => [
              vue.createVNode(vue.unref(elementPlus.ElDropdownMenu), null, {
                default: vue.withCtx(() => [
                  (vue.openBlock(true), vue.createElementBlock(
                    vue.Fragment,
                    null,
                    vue.renderList(moreButtons.value, (child, index) => {
                      return vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElDropdownItem), {
                        key: index,
                        disabled: !getActionEnabled(child),
                        icon: child.icon,
                        onClick: ($event) => onConfirmAction(child)
                      }, {
                        default: vue.withCtx(() => [
                          vue.createTextVNode(
                            vue.toDisplayString(child.text),
                            1
                            /* TEXT */
                          )
                        ]),
                        _: 2
                        /* DYNAMIC */
                      }, 1032, ["disabled", "icon", "onClick"]);
                    }),
                    128
                    /* KEYED_FRAGMENT */
                  ))
                ]),
                _: 1
                /* STABLE */
              })
            ]),
            default: vue.withCtx(() => [
              vue.createVNode(vue.unref(elementPlus.ElButton), {
                type: __props.buttonType,
                plain: __props.plain
              }, {
                default: vue.withCtx(() => [
                  vue.createTextVNode(
                    vue.toDisplayString(__props.moreButtonText),
                    1
                    /* TEXT */
                  ),
                  vue.createVNode(vue.unref(elementPlus.ElIcon), { class: "el-icon--right" }, {
                    default: vue.withCtx(() => [
                      vue.createVNode(vue.unref(index$1.ArrowDown))
                    ]),
                    _: 1
                    /* STABLE */
                  })
                ]),
                _: 1
                /* STABLE */
              }, 8, ["type", "plain"])
            ]),
            _: 1
            /* STABLE */
          }, 8, ["popper-class"])) : vue.createCommentVNode("v-if", true)
        ],
        6
        /* CLASS, STYLE */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=buttonGroup.vue2.js.map
