import type { MaybeRef } from '@vueuse/core';
export type LoadingOptionsResolved = {
    parent: LoadingParentElement;
    /**
     * 图标填充色
     */
    fillColor: MaybeRef<string>;
    /**
     * 图标动画填充色
     */
    animateColor: MaybeRef<string>;
    /**
     * 遮罩背景色
     */
    background: MaybeRef<string>;
    /**
     * 自定义 SVG 元素覆盖默认加载器
     */
    svg: MaybeRef<string>;
    /**
     * 设置用于加载 svg 元素的 viewBox 属性
     */
    svgViewBox: MaybeRef<string>;
    /**
     * 自定义加载图标类名
     */
    spinner: MaybeRef<boolean | string>;
    /**
     * 显示在加载图标下方的加载文案
     */
    text: MaybeRef<string>;
    /**
     * 同 v-cacploading 指令中的 fullscreen 修饰符
     */
    fullscreen: boolean;
    /**
     * 同 v-cacploading 指令中的 lock 修饰符
     */
    lock: boolean;
    /**
     * 	Loading 的自定义类名
     */
    customClass: MaybeRef<string>;
    visible: boolean;
    target: HTMLElement;
    beforeClose?: () => boolean;
    closed?: () => void;
};
export type LoadingOptions = Partial<Omit<LoadingOptionsResolved, 'parent' | 'target'> & {
    /**
     * @description the DOM node Loading needs to cover. Accepts a DOM object or a string. If it's a string, it will be passed to `document.querySelector` to get the corresponding DOM node
     */
    target: HTMLElement | string;
    /**
     * @description same as the `body` modifier of `v-cacploading`
     */
    body: boolean;
}>;
export interface LoadingParentElement extends HTMLElement {
    vLoadingAddClassList?: () => void;
}
