import { ref, nextTick, onMounted, watchEffect, onBeforeUnmount } from 'vue';
import { addUnit } from 'element-plus/es/utils/index';

var LastDialogStatus = /* @__PURE__ */ ((LastDialogStatus2) => {
  LastDialogStatus2[LastDialogStatus2["minus"] = 0] = "minus";
  LastDialogStatus2[LastDialogStatus2["fullscreen"] = 1] = "fullscreen";
  LastDialogStatus2[LastDialogStatus2["default"] = 2] = "default";
  return LastDialogStatus2;
})(LastDialogStatus || {});
const useDraggableAndResizable = (targetRef, dragRef, draggable, resizable, isFullscreen, alignCenter, overflow) => {
  const fullscreen = ref(false);
  const varWidth = "width";
  const varHeight = "height";
  const minus = ref(false);
  const dividerWidth = 5;
  let dialogBody;
  let transform = {
    offsetX: 0,
    offsetY: 0
  };
  let dialogWidth = "";
  let dialogHeight = "";
  let lastDialogStatus = 2 /* default */;
  const minSize = {
    width: 200,
    height: 72
  };
  const setTransform = () => {
    if (targetRef.value) {
      targetRef.value.style.left = transform.offsetX + "px";
      targetRef.value.style.top = transform.offsetY + "px";
    }
  };
  const onMousedown = (e) => {
    var _a;
    e.stopPropagation();
    const downX = e.clientX;
    const downY = e.clientY;
    const marginTop = parseFloat(getComputedStyle(targetRef.value).marginTop);
    const targetRect = targetRef.value.getBoundingClientRect();
    const targetLeft = targetRect.left;
    const targeTop = targetRect.top;
    const targeWidth = targetRect.width;
    const targeHeight = targetRect.height;
    const clientWidth = document.documentElement.clientWidth;
    const clientHeight = document.documentElement.clientHeight;
    const minLeft = 0;
    const minTop = 0 - marginTop;
    const maxLeft = clientWidth - targeWidth;
    const maxTop = clientHeight - targeHeight - marginTop;
    const activeIframe = getFirstVisibleIframe();
    dialogBody = (_a = targetRef.value) == null ? void 0 : _a.querySelector(".el-dialog__body");
    const onMousemove = (e2) => {
      if (activeIframe) {
        activeIframe.style.pointerEvents = "none";
      }
      if (dialogBody) {
        dialogBody.style.pointerEvents = "none";
      }
      document.body.style.userSelect = "none";
      let moveX = targetLeft + e2.clientX - downX;
      let moveY = targeTop + e2.clientY - downY - marginTop;
      if (!(overflow == null ? void 0 : overflow.value)) {
        moveX = Math.min(Math.max(moveX, minLeft), maxLeft);
        moveY = Math.min(Math.max(moveY, minTop), maxTop);
      }
      transform = {
        offsetX: moveX,
        offsetY: moveY
      };
      if (targetRef.value) {
        targetRef.value.style.left = `${addUnit(moveX)}`;
        targetRef.value.style.top = `${addUnit(moveY)}`;
      }
    };
    const onMouseup = () => {
      if (activeIframe) {
        activeIframe.style.pointerEvents = "";
      }
      if (dialogBody) {
        dialogBody.style.pointerEvents = "";
      }
      document.body.style.userSelect = "";
      document.removeEventListener("mousemove", onMousemove);
      document.removeEventListener("mouseup", onMouseup);
    };
    document.addEventListener("mousemove", onMousemove);
    document.addEventListener("mouseup", onMouseup);
  };
  const onResizeMousemove = (e) => {
    if (!resizable.value) return;
    if (minus.value) return;
    const { offsetWidth, offsetHeight, offsetLeft, offsetTop } = targetRef.value;
    if (e.clientX - offsetLeft < offsetWidth && e.clientX - offsetLeft > offsetWidth - dividerWidth && e.clientY - offsetTop < offsetHeight && e.clientY - offsetTop > offsetHeight - dividerWidth) {
      targetRef.value.style.cursor = "se-resize";
    } else if (e.clientX - offsetLeft <= dividerWidth && e.clientX - offsetLeft > 0 && e.clientY - offsetTop < offsetHeight && e.clientY - offsetTop > offsetHeight - dividerWidth) {
      targetRef.value.style.cursor = "sw-resize";
    } else if (e.clientX - offsetLeft <= dividerWidth) {
      targetRef.value.style.cursor = "w-resize";
    } else if (e.clientX - offsetLeft > offsetWidth - dividerWidth) {
      targetRef.value.style.cursor = "e-resize";
    } else if (e.clientY - offsetTop > offsetHeight - dividerWidth) {
      targetRef.value.style.cursor = "s-resize";
    } else {
      targetRef.value.style.cursor = "";
    }
  };
  const onResizeMousedown = (e) => {
    var _a;
    if (!resizable.value) return;
    if (minus.value) return;
    const activeIframe = getFirstVisibleIframe();
    const { clientX, clientY } = e;
    const marginTop = parseFloat(getComputedStyle(targetRef.value).marginTop);
    const targetRect = targetRef.value.getBoundingClientRect();
    const transX = targetRect.left;
    const transY = targetRect.top;
    const offsetWidth = targetRect.width;
    const offsetHeight = targetRect.height;
    const offsetX = clientX - transX;
    const offsetY = clientY - transY;
    transform = {
      offsetX: transX,
      offsetY: transY - marginTop
    };
    const maxWidth = document.documentElement.clientWidth;
    const maxHeight = document.documentElement.clientHeight;
    dialogBody = (_a = targetRef.value) == null ? void 0 : _a.querySelector(".el-dialog__body");
    const onDocumentMouseup = () => {
      document.removeEventListener("mousemove", onDocumentMousemove);
      document.removeEventListener("mouseup", onDocumentMouseup);
      targetRef.value.style.userSelect = "auto";
      if (dialogBody) {
        dialogBody.style.pointerEvents = "";
      }
      if (activeIframe) {
        activeIframe.style.pointerEvents = "";
      }
      document.body.style.userSelect = "";
    };
    const onDocumentMousemove = (e2) => {
      var _a2, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k;
      if (!targetRef.value) return;
      if (e2.clientX > maxWidth - 2 || e2.clientX < 1 || e2.clientY > maxHeight || e2.clientY < 1) {
        document.removeEventListener("mousemove", onDocumentMousemove);
        document.removeEventListener("mouseup", onDocumentMouseup);
        targetRef.value.style.userSelect = "auto";
        if (dialogBody) {
          dialogBody.style.pointerEvents = "";
        }
        if (activeIframe) {
          activeIframe.style.pointerEvents = "";
        }
        document.body.style.userSelect = "";
      } else {
        if (dialogBody) {
          dialogBody.style.pointerEvents = "none";
        }
        if (activeIframe) {
          activeIframe.style.pointerEvents = "none";
        }
        document.body.style.userSelect = "none";
        let moveX = transX;
        if (offsetX >= 0 && offsetX <= dividerWidth) {
          if (clientX > e2.clientX) {
            (_a2 = targetRef.value) == null ? void 0 : _a2.style.setProperty(
              varWidth,
              offsetWidth + (clientX - e2.clientX) + "px"
            );
            moveX = transX + (e2.clientX - clientX);
          } else if (clientX < e2.clientX) {
            if (offsetWidth - (e2.clientX - clientX) <= minSize.width) {
              (_b = targetRef.value) == null ? void 0 : _b.style.setProperty(varWidth, minSize.width + "px");
              moveX = transform.offsetX;
            } else {
              (_c = targetRef.value) == null ? void 0 : _c.style.setProperty(
                varWidth,
                offsetWidth - (e2.clientX - clientX) + "px"
              );
              moveX = Math.round(transX + (e2.clientX - clientX));
            }
          }
          transform = {
            offsetX: moveX,
            offsetY: transform.offsetY
          };
          setTransform();
          fullscreen.value = false;
        } else if (offsetX >= offsetWidth - 5 && offsetX <= offsetWidth) {
          if (clientX > e2.clientX) {
            if (offsetWidth - (clientX - e2.clientX) <= minSize.width) {
              (_d = targetRef.value) == null ? void 0 : _d.style.setProperty(varWidth, minSize.width + "px");
            } else {
              (_e = targetRef.value) == null ? void 0 : _e.style.setProperty(
                varWidth,
                offsetWidth - (clientX - e2.clientX) + "px"
              );
            }
          } else if (clientX < e2.clientX) {
            if (clientX < e2.clientX && e2.clientX < maxWidth) {
              if (offsetWidth + (e2.clientX - clientX) >= maxWidth) {
                (_f = targetRef.value) == null ? void 0 : _f.style.setProperty(varWidth, maxWidth + "px");
              } else {
                (_g = targetRef.value) == null ? void 0 : _g.style.setProperty(
                  varWidth,
                  offsetWidth + (e2.clientX - clientX) + "px"
                );
              }
            }
          }
          fullscreen.value = false;
        }
        if (offsetY > offsetHeight - dividerWidth && offsetY < offsetHeight) {
          if (clientY > e2.clientY) {
            if (offsetHeight - (clientY - e2.clientY) > minSize.height) {
              (_h = targetRef.value) == null ? void 0 : _h.style.setProperty(
                varHeight,
                offsetHeight - (clientY - e2.clientY) + "px"
              );
            } else {
              (_i = targetRef.value) == null ? void 0 : _i.style.setProperty(
                varHeight,
                minSize.height + "px"
              );
            }
          } else if (clientY < e2.clientY && e2.clientY < maxHeight) {
            if (offsetHeight + (e2.clientY - clientY) >= maxHeight) {
              (_j = targetRef.value) == null ? void 0 : _j.style.setProperty(varHeight, maxHeight + "px");
            } else {
              (_k = targetRef.value) == null ? void 0 : _k.style.setProperty(
                varHeight,
                offsetHeight + (e2.clientY - clientY) + "px"
              );
            }
          }
          fullscreen.value = false;
        }
      }
    };
    if (offsetX > dividerWidth && offsetX < offsetWidth - dividerWidth && offsetY > dividerWidth && offsetY < offsetHeight - dividerWidth) {
      return;
    } else {
      targetRef.value.style.userSelect = "none";
      document.addEventListener("mousemove", onDocumentMousemove);
      document.addEventListener("mouseup", onDocumentMouseup);
    }
  };
  const onDraggable = () => {
    if (dragRef.value && targetRef.value) {
      dragRef.value.addEventListener("mousedown", onMousedown);
    }
  };
  const offDraggable = () => {
    if (dragRef.value && targetRef.value) {
      dragRef.value.removeEventListener("mousedown", onMousedown);
    }
  };
  const onResizable = () => {
    if (targetRef.value) {
      targetRef.value.addEventListener("mousemove", onResizeMousemove);
      targetRef.value.addEventListener("mousedown", onResizeMousedown);
    }
  };
  const offResizable = () => {
    if (targetRef.value) {
      targetRef.value.removeEventListener("mousemove", onResizeMousemove);
      targetRef.value.removeEventListener("mousedown", onResizeMousedown);
    }
  };
  const resetPosition = () => {
    if (targetRef.value) {
      transform = {
        offsetX: 0,
        offsetY: 0
      };
      const targetRect = targetRef.value.getBoundingClientRect();
      const width = targetRect.width;
      const height = targetRect.height;
      const winWidth = window.innerWidth;
      const winHeight = window.innerHeight;
      targetRef.value.style.left = (winWidth - width) / 2 + "px";
      if (alignCenter.value) {
        targetRef.value.style.top = (winHeight - height) / 2 + "px";
      }
    }
  };
  const resetSize = () => {
    fullscreen.value = false;
    minus.value = false;
  };
  const fullscreenFn = () => {
    if (targetRef.value) {
      targetRef.value.style.left = "";
      targetRef.value.style.top = "";
      targetRef.value.style.setProperty(varWidth, "100%");
      targetRef.value.style.setProperty(varHeight, "100%");
    }
  };
  const minusFn = () => {
    if (targetRef.value) {
      targetRef.value.style.left = "";
      targetRef.value.style.top = "";
      targetRef.value.style.setProperty(varWidth, null);
      targetRef.value.style.setProperty(varHeight, null);
    }
  };
  const onExpand = () => {
    if (targetRef.value) {
      const style = window.getComputedStyle(targetRef.value);
      dialogWidth = style.getPropertyValue(varWidth);
      dialogHeight = style.getPropertyValue(varHeight);
    }
    minus.value = false;
    fullscreen.value = true;
    nextTick(() => {
      fullscreenFn();
    });
  };
  const onCompress = () => {
    minus.value = false;
    if (lastDialogStatus == 1 /* fullscreen */) {
      fullscreen.value = true;
      lastDialogStatus = 2 /* default */;
      nextTick(() => {
        fullscreenFn();
      });
    } else {
      fullscreen.value = false;
      nextTick(() => {
        if (targetRef.value) {
          targetRef.value.style.setProperty(varWidth, dialogWidth);
          targetRef.value.style.setProperty(varHeight, dialogHeight);
          resetPosition();
        }
      });
    }
  };
  const onMinus = () => {
    if (fullscreen.value) {
      lastDialogStatus = 1 /* fullscreen */;
    } else {
      lastDialogStatus = 2 /* default */;
      if (targetRef.value) {
        const style = window.getComputedStyle(targetRef.value);
        dialogWidth = style.getPropertyValue(varWidth);
        dialogHeight = style.getPropertyValue(varHeight);
      }
    }
    fullscreen.value = false;
    minus.value = true;
    nextTick(() => {
      minusFn();
    });
  };
  onMounted(() => {
    watchEffect(() => {
      fullscreen.value = isFullscreen.value;
    });
    watchEffect(() => {
      if (draggable.value) {
        onDraggable();
      } else {
        offDraggable();
      }
    });
    watchEffect(() => {
      if (resizable.value) {
        onResizable();
      } else {
        offResizable();
      }
    });
  });
  onBeforeUnmount(() => {
    offDraggable();
  });
  return {
    resetPosition,
    resetSize,
    onExpand,
    onCompress,
    onMinus,
    fullscreen,
    minus
  };
};
function getFirstVisibleIframe() {
  const iframes = document.getElementsByTagName("iframe");
  if (iframes.length > 0) {
    for (let i = 0; i < iframes.length; i++) {
      if (iframes[i].offsetWidth > 0 && iframes[i].offsetHeight > 0) {
        return iframes[i];
      }
    }
    return null;
  } else {
    return null;
  }
}

export { useDraggableAndResizable };
//# sourceMappingURL=index.mjs.map
