'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../hooks/index.js');
var elementPlus = require('element-plus');
require('./buttonGroup.vue.js');
var index = require('../../../hooks/use-namespace/index.js');
var buttonGroup_vue_vue_type_script_setup_true_lang = require('./buttonGroup.vue2.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpTableToolbar"
  },
  __name: "tableToolbar",
  props: {
    actions: { type: Array, required: false, default: () => [] },
    moreButtonText: { type: String, required: false, default: "\u66F4\u591A" },
    primaryColSpan: { type: Number, required: false },
    secondaryColSpan: { type: Number, required: false },
    rows: { type: Array, required: false, default: () => [] },
    space: { type: Number, required: false, default: 12 }
  },
  emits: ["on-command"],
  setup(__props, { emit: __emit }) {
    const bem = index.useNamespace("table");
    const props = __props;
    const emit = __emit;
    const onCommand = (command, rows) => {
      emit("on-command", command, rows);
    };
    const primaryActions = vue.computed(() => {
      return props.actions.filter(
        (item) => item.position == "left" || !item.position
      );
    });
    const secondaryActions = vue.computed(() => {
      return props.actions.filter((item) => item.position == "right");
    });
    const primaryColSpan = vue.computed(() => {
      if (props.primaryColSpan != void 0) {
        return props.primaryColSpan;
      } else {
        if (primaryActions.value.length > 0) {
          return 16;
        } else {
          return 0;
        }
      }
    });
    const secondaryColSpan = vue.computed(() => {
      if (props.secondaryColSpan != void 0) {
        return props.secondaryColSpan;
      } else {
        if (secondaryActions.value.length > 0) {
          return 8;
        } else {
          return 0;
        }
      }
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock(
        "div",
        {
          class: vue.normalizeClass(vue.unref(bem).e("toolbar"))
        },
        [
          vue.createVNode(vue.unref(elementPlus.ElRow), null, {
            default: vue.withCtx(() => [
              primaryActions.value.length > 0 ? (vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElCol), {
                key: 0,
                span: primaryColSpan.value
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(buttonGroup_vue_vue_type_script_setup_true_lang.default, {
                    actions: primaryActions.value,
                    moreButtonText: __props.moreButtonText,
                    rows: __props.rows,
                    buttonType: "primary",
                    space: __props.space,
                    plain: false,
                    onCommand
                  }, null, 8, ["actions", "moreButtonText", "rows", "space"])
                ]),
                _: 1
                /* STABLE */
              }, 8, ["span"])) : vue.createCommentVNode("v-if", true),
              secondaryActions.value.length > 0 ? (vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElCol), {
                key: 1,
                span: secondaryColSpan.value
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(buttonGroup_vue_vue_type_script_setup_true_lang.default, {
                    style: { "text-align": "right" },
                    actions: secondaryActions.value,
                    moreButtonText: __props.moreButtonText,
                    buttonType: "primary",
                    space: __props.space,
                    plain: true,
                    onCommand,
                    rows: __props.rows
                  }, null, 8, ["actions", "moreButtonText", "space", "rows"])
                ]),
                _: 1
                /* STABLE */
              }, 8, ["span"])) : vue.createCommentVNode("v-if", true)
            ]),
            _: 1
            /* STABLE */
          })
        ],
        2
        /* CLASS */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=tableToolbar.vue2.js.map
