'use strict';

require('./vue/index.js');
var istype = require('./tools/istype.js');
var tree = require('./tools/tree.js');
var security = require('./tools/security.js');
var throwError = require('./tools/throw-error.js');
var style = require('./style.js');
var install = require('./vue/install.js');



exports.isArray = istype.isArray;
exports.isBlob = istype.isBlob;
exports.isFile = istype.isFile;
exports.isFunction = istype.isFunction;
exports.isNumber = istype.isNumber;
exports.isObject = istype.isObject;
exports.isRegExp = istype.isRegExp;
exports.isString = istype.isString;
exports.isWindow = istype.isWindow;
exports.toTree = tree.toTree;
exports.deserialize = security.deserialize;
exports.serialize = security.serialize;
exports.throwError = throwError.throwError;
exports.addClass = style.addClass;
exports.addUnit = style.addUnit;
exports.classNameToArray = style.classNameToArray;
exports.getStyle = style.getStyle;
exports.hasClass = style.hasClass;
exports.isStringNumber = style.isStringNumber;
exports.removeClass = style.removeClass;
exports.removeStyle = style.removeStyle;
exports.setStyle = style.setStyle;
exports.withInstall = install.withInstall;
exports.withInstallDirective = install.withInstallDirective;
exports.withInstallFunction = install.withInstallFunction;
exports.withNoopInstall = install.withNoopInstall;
//# sourceMappingURL=index.js.map
