import { defineComponent, ref, nextTick, onMounted, onUnmounted, onUpdated, resolveComponent, openBlock, createElementBlock, Fragment, createElementVNode, normalizeClass, unref, withModifiers, renderSlot, createVNode, withCtx, createTextVNode, createCommentVNode } from 'vue';
import { debounce } from 'lodash-es';
import { Filter as filter_default } from '../../../../svg-icons/vue/dist/index.mjs';
import '../../../hooks/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpCollapsePanel"
  },
  __name: "collapsePanel",
  props: {
    collapse: { type: Boolean, required: false, default: true },
    selector: { type: String, required: false, default: ".el-col" }
  },
  emits: ["toggleEnd"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const bem = useNamespace("collapse");
    const props = __props;
    const collapse = ref(props.collapse);
    const minHeight = ref(0);
    const maxHeight = ref(0);
    const collapseSelector = ref(props.selector);
    const collapseDom = ref(null);
    const wrapperDom = ref(null);
    const showToggle = ref(false);
    let enableEmit = false;
    let needUpdate = true;
    let resizeObsever;
    const init = async () => {
      var _a;
      collapseDom.value = (_a = wrapperDom.value) == null ? void 0 : _a.querySelector(collapseSelector.value);
      if (collapseDom.value) {
        if (getComputedStyle(collapseDom.value).display === "none") {
          collapseDom.value.style.display = "";
        }
        minHeight.value = collapseDom.value.offsetHeight;
        maxHeight.value = wrapperDom.value.scrollHeight;
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
        await nextTick();
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.transition = "max-height linear 0.3s";
      }
    };
    const resize = () => {
      enableEmit = false;
      if (collapseDom.value && collapseDom.value.offsetHeight > 0) {
        minHeight.value = collapseDom.value.offsetHeight;
        maxHeight.value = wrapperDom.value.scrollHeight;
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const modeChangeResize = () => {
      var _a;
      (_a = wrapperDom.value) == null ? void 0 : _a.addEventListener("transitionend", resize, { once: true });
    };
    const onToggle = () => {
      enableEmit = true;
      needUpdate = false;
      collapse.value = !collapse.value;
      if (wrapperDom.value) {
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const emit = __emit;
    const onToggleEnd = () => {
      if (enableEmit) {
        emit("toggleEnd", collapse.value);
      }
    };
    __expose({ onToggle });
    let debounceResize = debounce(resize, 100);
    onMounted(() => {
      init();
      window.addEventListener("resize", debounceResize);
      window.addEventListener("modeChange", modeChangeResize);
      if ((wrapperDom == null ? void 0 : wrapperDom.value) && ResizeObserver) {
        resizeObsever = new ResizeObserver(debounceResize);
        resizeObsever.observe(wrapperDom == null ? void 0 : wrapperDom.value);
      }
    });
    onUnmounted(() => {
      window.removeEventListener("resize", debounceResize);
      window.removeEventListener("modeChange", modeChangeResize);
      resizeObsever == null ? void 0 : resizeObsever.disconnect();
    });
    onUpdated(() => {
      if (needUpdate) {
        resize();
        needUpdate = false;
      }
      nextTick(() => {
        needUpdate = true;
      });
    });
    return (_ctx, _cache) => {
      const _component_el_link = resolveComponent("el-link");
      return openBlock(), createElementBlock(
        Fragment,
        null,
        [
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(bem).m("panel")),
              ref_key: "wrapperDom",
              ref: wrapperDom,
              onTransitionend: withModifiers(onToggleEnd, ["self"])
            },
            [
              renderSlot(_ctx.$slots, "content")
            ],
            34
            /* CLASS, NEED_HYDRATION */
          ),
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(bem).m("footer"))
            },
            [
              renderSlot(_ctx.$slots, "footer"),
              showToggle.value ? renderSlot(_ctx.$slots, "toggle", {
                key: 0,
                collapsed: collapse.value,
                onToggle
              }, () => [
                createVNode(_component_el_link, {
                  onClick: onToggle,
                  type: "primary",
                  underline: false,
                  icon: unref(filter_default),
                  class: normalizeClass(unref(bem).e("toggle"))
                }, {
                  default: withCtx(() => [
                    createTextVNode("\u9AD8\u7EA7\u67E5\u8BE2")
                  ]),
                  _: 1
                  /* STABLE */
                }, 8, ["icon", "class"])
              ]) : createCommentVNode("v-if", true)
            ],
            2
            /* CLASS */
          )
        ],
        64
        /* STABLE_FRAGMENT */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=collapsePanel.vue2.mjs.map
