import { defineComponent, computed, openBlock, createBlock, unref, withCtx, createVNode, createElementBlock, Fragment, renderList, createTextVNode, toDisplayString } from 'vue';
import '../../../utils/index.mjs';
import { ElMessageBox, ElTableColumn, ElSpace, ElLink } from 'element-plus';
import { isFunction, isString } from '../../../utils/tools/istype.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpTableOperator"
  },
  __name: "TableOperator",
  props: {
    actions: { type: Array, required: false, default: () => [] },
    width: { type: Number, required: false },
    title: { type: String, required: false, default: "\u64CD\u4F5C" }
  },
  emits: ["inline-action"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const actionsWidth = computed(() => {
      if (props.width) {
        return props.width;
      }
      if (props.actions.length >= 4) {
        return 312;
      }
      if (props.actions.length === 3) {
        return 238;
      }
      if (props.actions.length === 2) {
        return 168;
      }
      return 98;
    });
    function getAvailbleActions(row) {
      return props.actions.filter((action) => {
        return isEnabled(action, row);
      });
    }
    function isEnabled(action, row) {
      if (isFunction(action.disabled)) {
        return !action.disabled(row);
      } else if (action.disabled) {
        return false;
      }
      return true;
    }
    function getConfirmText(confirm) {
      if (isString(confirm)) {
        return confirm;
      }
      return "\u60A8\u786E\u5B9A\u8BE5\u64CD\u4F5C\uFF1F";
    }
    function onConfirmAction(action, row, rowIndex) {
      if (!isEnabled(action, row)) {
        return;
      }
      if (action.confirm) {
        ElMessageBox.confirm(getConfirmText(action.confirm), "\u63D0\u793A", { type: "warning", cancelButtonText: "\u53D6\u6D88", confirmButtonText: "\u786E\u5B9A" }).then(() => {
          onAction(action, row, rowIndex);
        }).catch(() => {
        });
      } else {
        onAction(action, row, rowIndex);
      }
    }
    function onAction(action, row, rowIndex) {
      if (action.onclick) {
        if (isFunction(action.onclick)) {
          action.onclick(row, rowIndex);
        } else {
          emit("inline-action", action.onclick, row, rowIndex);
        }
      }
    }
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ElTableColumn), {
        fixed: "right",
        label: __props.title,
        width: actionsWidth.value
      }, {
        default: withCtx((scope) => [
          createVNode(
            unref(ElSpace),
            null,
            {
              default: withCtx(() => [
                (openBlock(true), createElementBlock(
                  Fragment,
                  null,
                  renderList(getAvailbleActions(scope.row), (action) => {
                    return openBlock(), createBlock(unref(ElLink), {
                      key: action.key,
                      type: "primary",
                      title: action.tooltip,
                      icon: action.icon,
                      onClick: ($event) => onConfirmAction(action, scope.row, scope.$index)
                    }, {
                      default: withCtx(() => [
                        createTextVNode(
                          toDisplayString(action.text),
                          1
                          /* TEXT */
                        )
                      ]),
                      _: 2
                      /* DYNAMIC */
                    }, 1032, ["title", "icon", "onClick"]);
                  }),
                  128
                  /* KEYED_FRAGMENT */
                ))
              ]),
              _: 2
              /* DYNAMIC */
            },
            1024
            /* DYNAMIC_SLOTS */
          )
        ]),
        _: 1
        /* STABLE */
      }, 8, ["label", "width"]);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=TableOperator.vue2.mjs.map
