import { isClient } from '@vueuse/core';

function getCookieByName(name) {
  const cookies = document.cookie.split(";");
  for (const cookie of cookies) {
    if (cookie.startsWith(name + "=")) {
      const value = cookie.substring(name.length + 1);
      return value;
    }
  }
  return null;
}
function getTopCookie(name = "x-customs-user", callback) {
  if (!isClient) return;
  if (window.top === window.self) {
    callback(getCookieByName(name));
  } else {
    let func;
    top == null ? void 0 : top.postMessage({ type: "getTopCookie", name }, "*");
    window.addEventListener(
      "message",
      func = (e) => {
        var _a, _b;
        if (((_a = e.data) == null ? void 0 : _a.type) === "setTopCookie") {
          callback((_b = e.data) == null ? void 0 : _b.cookie);
          window.removeEventListener("message", func);
        }
      }
    );
  }
}
function initCookieListen() {
  if (!isClient) return;
  if (window.top === window.self) {
    top == null ? void 0 : top.addEventListener("message", onMessageHandler);
    top == null ? void 0 : top.addEventListener("beforeunload", () => {
      top == null ? void 0 : top.removeEventListener("message", onMessageHandler);
    });
  }
}
function onMessageHandler(event) {
  var _a;
  if (event.data !== null && !Array.isArray(event.data) && typeof event.data === "object") {
    if (((_a = event.data) == null ? void 0 : _a.type) === "getTopCookie") {
      getTopCookie(event.data.name, (cookie) => {
        var _a2;
        (_a2 = event.source) == null ? void 0 : _a2.postMessage(
          { type: "setTopCookie", cookie },
          {
            targetOrigin: event.origin
          }
        );
      });
    }
  }
}

export { getTopCookie, initCookieListen };
//# sourceMappingURL=index.mjs.map
