const opt = Object.prototype.toString;
function isFunction(obj) {
  return typeof obj === "function";
}
function isString(obj) {
  return opt.call(obj) === "[object String]";
}
function isObject(obj) {
  return opt.call(obj) === "[object Object]";
}
function isArray(obj) {
  return opt.call(obj) === "[object Array]";
}
function isNumber(obj) {
  return opt.call(obj) === "[object Number]" && obj === obj;
}
function isFile(obj) {
  return opt.call(obj) === "[object File]";
}
function isRegExp(obj) {
  return opt.call(obj) === "[object RegExp]";
}
function isBlob(obj) {
  return opt.call(obj) === "[object Blob]";
}
function isWindow(obj) {
  return obj === window;
}

export { isArray, isBlob, isFile, isFunction, isNumber, isObject, isRegExp, isString, isWindow };
//# sourceMappingURL=istype.mjs.map
