function toTreeRecursion(list, item, codeProp, parentProp, leafProp, mergeFunc) {
  if (leafProp && item[leafProp]) {
    return;
  }
  const children = list.filter((t) => t[parentProp] === item[codeProp]).map((t) => {
    if (mergeFunc) {
      return Object.assign({}, t, mergeFunc(t));
    } else {
      return Object.assign({}, t);
    }
  });
  if (!leafProp && children.length === 0) {
    return;
  }
  children.forEach(
    (t) => toTreeRecursion(list, t, codeProp, parentProp, leafProp, mergeFunc)
  );
  item.children = children;
}
function toTree(list, rootCode, codeProp, parentProp, leafProp, mergeFunc) {
  return list.filter((t) => t[parentProp] === rootCode).map((t) => {
    const item = mergeFunc ? Object.assign({}, t, mergeFunc(t)) : Object.assign({}, t);
    toTreeRecursion(list, item, codeProp, parentProp, leafProp, mergeFunc);
    return item;
  });
}

export { toTree };
//# sourceMappingURL=tree.mjs.map
