export type HeaiMessageStep = 'CREATED' | 'SEND' | 'RECEIVED' | 'COMPLETED';
export type HeaiMessageFlag = 'WAITING' | 'COMPLETED' | 'ERROR';
export interface HeaiMessageTypeInfo {
    typeCode: string;
    appCode: string;
    senderId: string;
    receiverId: string;
    channel: string;
    contentType: string;
    messageDirect: boolean;
    respRequired: boolean;
    respType: string;
    requireResp: boolean;
}
export interface HeaiMessageInfo {
    appMsgId: string;
    heaiId: string;
    messageId: string;
    bizId: string;
    messageType: string;
    filePath: string;
    retryCount: number;
    completed: boolean;
    lastTime: string;
    content: string;
    workflowList: Array<HeaiMessageWorkflowInfo>;
}
export interface HeaiMessageWorkflowInfo {
    appMsgId: string;
    createTime: string;
    stepCode: HeaiMessageStep;
    success: boolean;
    resultCode: string;
    resultMessage: string;
}
export interface HeaiMessageQueryInfo {
    type: boolean;
    flag: HeaiMessageFlag;
    appMsgId: string;
    messageType: string;
    bizId: string;
    searchKey: string;
    beginDate: string;
    endDate: string;
    pageIndex: number;
    pageSize: number;
}
