export interface DelegateInfo {
    delegateId: string;
    assignParentId: string;
    assignUserId: string;
    assignUserPath: string;
    delegateParentId: string;
    delegateUserId: string;
    delegateUserPath: string;
    begDate: string;
    endDate: string;
}
export interface FrameThemeTypeInfo {
    themeCode: string;
    themeName: string;
}
export interface FrameThemeInfo {
    userId: string;
    userName: string;
    themeCode: string;
    elderMode: boolean;
    forceFlag: boolean;
}
export interface FrameUserInfo {
    userId: string;
    userName: string;
    parentId: string;
    fullPathName: string;
    personId: string;
    customsCode: string;
    status: string;
    sortOrder: string;
    email: string;
    mobile: string;
    rankCode: string;
    rankName: string;
    sideline: boolean;
    ipAddress: string;
    viewCode: string;
    logonType: string;
    logonTime: string;
}
export interface FrameConfigInfo {
    user: FrameUserInfo;
    theme: FrameThemeInfo;
    themeTypeList: Array<FrameThemeTypeInfo>;
    delegates: Array<DelegateInfo>;
    extraAttrs: Record<string, string>;
}
