export type ScheduleType = 'NONE' | 'CRON' | 'REPEAT' | 'AFTER';
export type BalanceStrategy = 'DEFAULT' | 'ROUND_ROBIN';
export type DistributedType = 'SLICE' | 'ONLYONE';
export type ScheduleStatus = 'STARTED' | 'STOPPED' | 'STARTING' | 'STOPPING';
export type ExecFlag = 'SUCCESS' | 'FAILURE' | 'RUNNING' | 'NONE';
export interface JobDefinition {
    jobCode: string;
    appCode: string;
    jobName: string;
    fullClassName: string;
    scheduleType: ScheduleType;
    distributedType: DistributedType;
    scheduleTime: string;
    jobConfig: string;
    scheduleStatus: ScheduleStatus;
    jobStatus: boolean;
}
export interface JobRuntime {
    nodeId: string;
    jobCode: string;
    appCode: string;
    jobName: string;
    logId: string;
    execFlag: ExecFlag;
    startTime: string;
    endTime: string;
    notes: string;
    createTime: string;
}
export interface JobNode {
    nodeId: string;
    running: boolean;
    master: boolean;
    jobCount: number;
    lastTime: string;
}
