'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var index$1 = require('../../../../svg-icons/vue/dist/index.js');
require('../../../hooks/index.js');
var index = require('../../../hooks/use-namespace/index.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpCollapseContainer"
  },
  __name: "collapseContainer",
  props: {
    collapse: { type: Boolean, required: false, default: false },
    title: { type: String, required: false, default: "" }
  },
  emits: ["toggleEnd"],
  setup(__props, { emit: __emit }) {
    const bem = index.useNamespace("collapse");
    const emit = __emit;
    const props = __props;
    const state = vue.reactive({
      isCollapse: props.collapse
    });
    function toggle() {
      state.isCollapse = !state.isCollapse;
    }
    const onToggleEnd = () => {
      emit("toggleEnd", state.isCollapse);
    };
    return (_ctx, _cache) => {
      const _component_el_icon = vue.resolveComponent("el-icon");
      const _component_el_collapse_transition = vue.resolveComponent("el-collapse-transition");
      return vue.openBlock(), vue.createElementBlock(
        "div",
        {
          class: vue.normalizeClass(vue.unref(bem).e("container"))
        },
        [
          vue.createElementVNode(
            "div",
            {
              class: vue.normalizeClass(vue.unref(bem).e("header"))
            },
            [
              vue.renderSlot(_ctx.$slots, "title", {}, () => [
                vue.createElementVNode(
                  "div",
                  {
                    class: vue.normalizeClass(vue.unref(bem).e("title"))
                  },
                  vue.toDisplayString(__props.title),
                  3
                  /* TEXT, CLASS */
                )
              ]),
              vue.createVNode(_component_el_icon, {
                class: vue.normalizeClass(vue.unref(bem).em("header", "arrow")),
                onClick: toggle
              }, {
                default: vue.withCtx(() => [
                  (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(state.isCollapse ? vue.unref(index$1.ArrowDown) : vue.unref(index$1.ArrowUp))))
                ]),
                _: 1
                /* STABLE */
              }, 8, ["class"])
            ],
            2
            /* CLASS */
          ),
          vue.createVNode(_component_el_collapse_transition, null, {
            default: vue.withCtx(() => [
              vue.withDirectives(vue.createElementVNode(
                "div",
                {
                  class: vue.normalizeClass(vue.unref(bem).e("content")),
                  onTransitionend: vue.withModifiers(onToggleEnd, ["self"])
                },
                [
                  vue.renderSlot(_ctx.$slots, "content")
                ],
                34
                /* CLASS, NEED_HYDRATION */
              ), [
                [vue.vShow, !state.isCollapse]
              ])
            ]),
            _: 3
            /* FORWARDED */
          })
        ],
        2
        /* CLASS */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=collapseContainer.vue2.js.map
