'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../hooks/index.js');
var elementPlus = require('element-plus');
var index$1 = require('../../collapse-panel/index.js');
var index = require('../../../hooks/use-namespace/index.js');

const SearchPanelLayout = vue.defineComponent({
  name: "CacpSearchPanelLayout",
  props: {
    // ElCol组件的间距
    gutter: {
      type: Number,
      default: 30
    },
    // 当查询条件行数超过一行之后是否启用自动折叠。不包括初始一行，屏幕改变变为多行的情况，这种情况不会折叠查询面板
    enableExpand: {
      type: Boolean,
      default: true
    },
    // 每个组件占据的列数，一行默认分为24列，当值为数字的时候，默认为所有组件占据相同的列数
    // 如果传入值是数组时，只有数组下标对应的组件会被指定为传入的值，其他的组件默认占据6列
    colSpan: {
      type: [Array, Number],
      default: 6
    },
    // 当enableExpand为true的时候，初始折叠状态
    collapse: {
      type: Boolean,
      default: true
    },
    // 用于选择一个元素，组件基于这个元素的高度来设置折叠时候的高度
    collapseSelector: {
      type: String,
      default: ".el-col"
    }
  },
  inheritAttrs: false,
  setup(props, { slots, attrs, emit, expose }) {
    const ns = index.useNamespace("search");
    vue.provide("ns", ns);
    const formRef = vue.ref();
    const resetFields = () => {
      var _a;
      (_a = formRef.value) == null ? void 0 : _a.resetFields();
    };
    const validate = (callback) => {
      var _a;
      return (_a = formRef.value) == null ? void 0 : _a.validate(callback);
    };
    const validateField = (props2, callback) => {
      var _a;
      return (_a = formRef.value) == null ? void 0 : _a.validateField(props2, callback);
    };
    const scrollToField = (prop) => {
      var _a;
      (_a = formRef.value) == null ? void 0 : _a.scrollToField(prop);
    };
    const clearValidate = (props2) => {
      var _a;
      (_a = formRef.value) == null ? void 0 : _a.clearValidate(props2);
    };
    const onToggleEnd = (status) => {
      emit("toggleEnd", status);
    };
    expose({
      formRef,
      resetFields,
      validate,
      validateField,
      scrollToField,
      clearValidate
    });
    const renderItem = (item, index) => {
      const span = typeof props.colSpan == "number" ? props.colSpan : props.colSpan[index] || 6;
      if (item.type.toString() === "Symbol(v-fgt)") {
        if (Array.isArray(item.children)) {
          if (vue.isVNode(item.children[0])) {
            if (item.children[0].children === "v-if" || item.children[0].children === "") {
              return false;
            }
          }
        }
      }
      if (item.children === "v-if" || item.children === "") {
        return false;
      }
      let visible = true;
      if (item.dirs) {
        const show = item.dirs.find((item2) => {
          return item2.dir.name === "show";
        });
        if (show && !show.value) {
          visible = false;
        }
      }
      return {
        node: vue.h(
          elementPlus.ElCol,
          {
            xl: span,
            lg: span,
            md: 8,
            sm: 12,
            style: { display: visible ? null : "none" }
          },
          { default: () => item }
        ),
        span
      };
    };
    return () => {
      var _a;
      const defaultsList = (_a = slots.default) == null ? void 0 : _a.call(slots);
      const defaultSlots = [];
      const buttonGroupSlots = [];
      let wrapper;
      let colCount = 0;
      let indexNumber = 0;
      if (defaultsList !== void 0) {
        defaultsList.forEach((item) => {
          var _a2;
          if (item.type.toString() === "Symbol(v-fgt)" || item.type.toString() === "template") {
            if (Array.isArray(item.children)) {
              (_a2 = item.children) == null ? void 0 : _a2.forEach((subItem) => {
                if (vue.isVNode(subItem)) {
                  const res = renderItem(subItem, indexNumber);
                  if (res !== false) {
                    defaultSlots.push(res.node);
                    colCount += res.span;
                  }
                  indexNumber++;
                }
              });
            }
          } else {
            const res = renderItem(item, indexNumber);
            if (res !== false) {
              defaultSlots.push(res.node);
              colCount += res.span;
            }
            indexNumber++;
          }
        });
      }
      if (slots.buttonGroup != void 0) {
        const buttonGroup = slots.buttonGroup();
        if (colCount > 20 || buttonGroup.length > 2) {
          buttonGroupSlots.push(
            vue.h(
              elementPlus.ElCol,
              { span: 24, style: { textAlign: "center" } },
              { default: () => buttonGroup }
            )
          );
        } else {
          const span = 24 - colCount;
          defaultSlots.push(
            vue.h(
              elementPlus.ElCol,
              { xl: span, lg: span, md: 8, sm: 12 },
              { default: () => buttonGroup }
            )
          );
        }
      }
      if (props.enableExpand && buttonGroupSlots.length > 0) {
        const form = vue.h(
          elementPlus.ElForm,
          { ...attrs, ref: formRef },
          {
            default: () => vue.h(
              elementPlus.ElRow,
              { gutter: props.gutter },
              { default: () => defaultSlots }
            )
          }
        );
        wrapper = vue.h(
          index$1.CacpCollapsePanel,
          {
            selector: props.collapseSelector,
            collapse: props.collapse,
            onToggleEnd
          },
          {
            content: () => form,
            footer: () => buttonGroupSlots,
            toggle: (props2) => {
              var _a2;
              return (_a2 = slots.toggle) == null ? void 0 : _a2.call(slots, props2);
            }
          }
        );
      } else {
        wrapper = vue.h(
          elementPlus.ElForm,
          { ...attrs, ref: formRef },
          {
            default: () => vue.h(
              elementPlus.ElRow,
              { gutter: props.gutter },
              { default: () => [...defaultSlots, ...buttonGroupSlots] }
            )
          }
        );
      }
      return vue.h(
        "div",
        {
          class: ns.e("panel")
        },
        [wrapper]
      );
    };
  }
});

exports.default = SearchPanelLayout;
//# sourceMappingURL=layout.js.map
