'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@vueuse/core');

const localStorageKey = "currentThemeValue";
function initTheme() {
  if (core.isClient) {
    const theme = localStorage.getItem(localStorageKey) || "";
    if (theme) {
      document.documentElement.classList.add(theme);
    }
    window.addEventListener("storage", onStorageHandler);
    window.addEventListener("message", onMessageHandler);
    window.addEventListener(
      "beforeunload",
      () => {
        window.removeEventListener("message", onMessageHandler);
        window.removeEventListener("storage", onStorageHandler);
      },
      { once: true }
    );
  }
}
function changeTheme(theme, oldTheme) {
  var _a;
  if (core.isClient) {
    const _oldTheme = oldTheme || localStorage.getItem(localStorageKey) || "";
    if (_oldTheme) {
      document.documentElement.classList.remove(_oldTheme);
    }
    if (theme.trim() === "") {
      document.documentElement.classList.add(theme);
    }
    localStorage.setItem(localStorageKey, theme);
    if (window.top == window.self) {
      const iframes = document.getElementsByTagName("iframe");
      for (let i = 0; i < iframes.length; i++) {
        const iframe = iframes[i];
        (_a = iframe.contentWindow) == null ? void 0 : _a.postMessage(
          { type: "changeTheme", theme, oldTheme: _oldTheme },
          "*"
        );
      }
    }
  }
}
function onMessageHandler(event) {
  var _a;
  if (event.data !== null && !Array.isArray(event.data) && typeof event.data === "object") {
    if (((_a = event.data) == null ? void 0 : _a.type) === "changeTheme") {
      changeTheme(event.data.theme, event.data.oldTheme);
    }
  }
}
function onStorageHandler(event) {
  if (event.key == localStorageKey) {
    if (event.oldValue == event.newValue) return;
    if (event.oldValue) {
      document.documentElement.classList.remove(event.oldValue);
    }
    if (event.newValue) {
      document.documentElement.classList.add(event.newValue);
    }
  }
}
const CacpSwitchTheme = {
  install(app) {
    initTheme();
    app.config.globalProperties.$switchTheme = changeTheme;
  }
};

exports.CacpSwitchTheme = CacpSwitchTheme;
exports.changeTheme = changeTheme;
exports.default = CacpSwitchTheme;
exports.initTheme = initTheme;
//# sourceMappingURL=index.js.map
