'use strict';

var vue = require('vue');

const defaultNamespace = "cacp";
const statePrefix = "is-";
const _bem = (namespace, block, blockSuffix, element, modifier) => {
  let cls = `${namespace}-${block}`;
  if (blockSuffix && blockSuffix !== "") {
    cls += `-${blockSuffix}`;
  }
  if (element) {
    cls += `__${element}`;
  }
  if (modifier) {
    cls += `--${modifier}`;
  }
  return cls;
};
const useNamespace = (block) => {
  const namespace = vue.computed(() => defaultNamespace);
  const b = (blockSuffix = "") => {
    return _bem(vue.unref(namespace), block, blockSuffix, "", "");
  };
  const e = (element) => {
    return element ? _bem(vue.unref(namespace), block, "", element, "") : "";
  };
  const m = (modifier) => {
    return modifier ? _bem(vue.unref(namespace), block, "", "", modifier) : "";
  };
  const be = (blockSuffix, element) => {
    return blockSuffix && element ? _bem(vue.unref(namespace), block, blockSuffix, element, "") : "";
  };
  const em = (element, modifier) => {
    return element && modifier ? _bem(vue.unref(namespace), block, "", element, modifier) : "";
  };
  const bm = (blockSuffix, modifier) => {
    return blockSuffix && modifier ? _bem(vue.unref(namespace), block, blockSuffix, "", modifier) : "";
  };
  const bem = (blockSuffix, element, modifier) => {
    return blockSuffix && element && modifier ? _bem(vue.unref(namespace), block, blockSuffix, element, modifier) : "";
  };
  const is = (name, ...args) => {
    const state = args.length >= 1 ? args[0] : true;
    return name && state ? `${statePrefix}${name}` : "";
  };
  return {
    namespace,
    b,
    e,
    m,
    be,
    em,
    bm,
    bem,
    is
  };
};

exports.defaultNamespace = defaultNamespace;
exports.useNamespace = useNamespace;
//# sourceMappingURL=index.js.map
