import { defineComponent, ref, computed, resolveDirective, openBlock, createElementBlock, normalizeClass, unref, renderSlot, createCommentVNode, createVNode, createElementVNode, withDirectives, createBlock, mergeProps, createSlots, withCtx } from 'vue';
import { ElTable, ElTableColumn, ElPagination } from 'element-plus';
import './TableOperator.vue.mjs';
import '../../../hooks/index.mjs';
import { CacpTableToolbar } from '../../table-toolbar/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import _sfc_main$1 from './TableOperator.vue2.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpComplexTable",
    inheritAttrs: false
  },
  __name: "ComplexTable",
  props: {
    class: { required: false },
    style: { required: false },
    actions: { type: Array, required: true, default: () => [] },
    actionSpace: { type: Number, required: false, default: 12 },
    moreButtonText: { type: String, required: false },
    primaryColSpan: { type: Number, required: false },
    secondaryColSpan: { type: Number, required: false },
    actionsWidth: { type: Number, required: false },
    actionsTitle: { type: String, required: false, default: "\u64CD\u4F5C" },
    data: { type: Array, required: true },
    pagination: { type: Object, required: false },
    titleIsinline: { type: Boolean, required: false },
    loading: { type: Boolean, required: false, default: false },
    layout: { type: String, required: false },
    pageSizes: { type: Array, required: false }
  },
  emits: ["on-page-change", "on-size-change", "on-command"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const bem = useNamespace("advance");
    const innerTableRef = ref();
    const emits = __emit;
    const props = __props;
    __expose({
      innerTableRef
    });
    const enableSelection = computed(() => {
      return props.actions.some((item) => item.limit === "more");
    });
    const theadActions = computed(() => {
      return props.actions.filter((item) => item.position !== void 0 || item.limit === "more" || item.limit === "none");
    });
    const inlineActions = computed(() => {
      return props.actions.filter((item) => item.position === void 0 && item.limit === "one");
    });
    const hasToolBar = computed(() => {
      return theadActions.value.length > 0;
    });
    const hasOne = computed(() => {
      return inlineActions.value.length > 0;
    });
    const selectedRows = ref([]);
    function isSelectedRow({ row }) {
      const isSelected = selectedRows.value.includes(row);
      if (isSelected) {
        return "is-selected";
      }
      return void 0;
    }
    function onSelectionChange(rows) {
      selectedRows.value = rows;
    }
    function onPageChange(currentPage) {
      if (props.pagination && props.pagination.visible) {
        emits("on-page-change", currentPage);
      }
    }
    function onSizeChange(pageSize) {
      if (props.pagination && props.pagination.visible) {
        emits("on-size-change", pageSize);
      }
    }
    function onInlineAction(command, rows, rowIndex) {
      emits("on-command", command, rows, rowIndex);
    }
    function onCommand(command, rows) {
      emits("on-command", command, rows);
    }
    return (_ctx, _cache) => {
      const _directive_cacploading = resolveDirective("cacploading");
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass([unref(bem).e("layout"), _ctx.$props.class])
        },
        [
          hasToolBar.value || _ctx.$slots.title ? (openBlock(), createElementBlock(
            "div",
            {
              key: 0,
              class: normalizeClass([unref(bem).e("toolbar"), __props.titleIsinline ? "is-line" : ""])
            },
            [
              _ctx.$slots.title ? renderSlot(_ctx.$slots, "title", { key: 0 }) : createCommentVNode("v-if", true),
              createVNode(unref(CacpTableToolbar), {
                rows: selectedRows.value,
                actions: theadActions.value,
                onOnCommand: onCommand,
                primaryColSpan: __props.primaryColSpan,
                secondaryColSpan: __props.secondaryColSpan,
                moreButtonText: __props.moreButtonText,
                space: __props.actionSpace
              }, null, 8, ["rows", "actions", "primaryColSpan", "secondaryColSpan", "moreButtonText", "space"])
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true),
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(bem).e("grid"))
            },
            [
              withDirectives((openBlock(), createBlock(unref(ElTable), mergeProps({
                ref_key: "innerTableRef",
                ref: innerTableRef,
                data: __props.data,
                onSelectionChange
              }, _ctx.$attrs, {
                class: "table-inner",
                "row-class-name": isSelectedRow
              }), createSlots({
                default: withCtx(() => [
                  enableSelection.value ? (openBlock(), createBlock(unref(ElTableColumn), {
                    key: 0,
                    fixed: "",
                    type: "selection",
                    width: "50"
                  })) : createCommentVNode("v-if", true),
                  renderSlot(_ctx.$slots, "default"),
                  hasOne.value ? (openBlock(), createBlock(_sfc_main$1, {
                    key: 1,
                    actions: inlineActions.value,
                    title: __props.actionsTitle,
                    onInlineAction,
                    width: __props.actionsWidth
                  }, null, 8, ["actions", "title", "width"])) : createCommentVNode("v-if", true)
                ]),
                _: 2
                /* DYNAMIC */
              }, [
                _ctx.$slots.append ? {
                  name: "append",
                  fn: withCtx(() => [
                    renderSlot(_ctx.$slots, "append")
                  ]),
                  key: "0"
                } : void 0
              ]), 1040, ["data"])), [
                [_directive_cacploading, __props.loading]
              ])
            ],
            2
            /* CLASS */
          ),
          __props.pagination && __props.pagination.visible ? (openBlock(), createElementBlock(
            "div",
            {
              key: 1,
              class: normalizeClass(unref(bem).e("pagination"))
            },
            [
              createVNode(unref(ElPagination), mergeProps({
                background: "",
                "current-page": __props.pagination.currentPage,
                "page-size": __props.pagination.pageSize,
                "onUpdate:currentPage": onPageChange,
                "onUpdate:pageSize": onSizeChange
              }, __props.pagination, {
                total: __props.pagination.total,
                layout: __props.layout || "total,sizes,->, prev, pager, next, jumper",
                pageSizes: __props.pageSizes
              }), null, 16, ["current-page", "page-size", "total", "layout", "pageSizes"])
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true)
        ],
        2
        /* CLASS */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=ComplexTable.vue2.mjs.map
