import type { ButtonType } from 'element-plus';
import { Component } from 'vue';
export type TableActionMode = 'none' | 'one' | 'more';
export type ActionPosition = 'left' | 'right';
export interface TableAction {
    key: string;
    type?: ButtonType;
    position?: ActionPosition;
    limit?: TableActionMode;
    icon?: string | Component;
    plain?: boolean;
    text?: string;
    tooltip?: string;
    disabled?: boolean | ((row?: any) => boolean);
    confirm?: boolean | string;
    onclick: string | ((row?: any, index?: number) => void);
    children?: Array<TableAction>;
}
export type { ButtonType };
