'use strict';

var core = require('@vueuse/core');

const COOKIE_TYPE = "cookie";
const GET_COOKIE_TYPE = "get-top-cookie";
const FRAME_USER_INFO_TYPE = "frame-user-info";
const FRAME_REFRESH = "frame-refresh";
function postMessage(target, message, origin = "*") {
  if (target) {
    target.postMessage(message, { targetOrigin: origin });
  }
}
function addMessageListener() {
  if (core.isClient) {
    window.addEventListener("message", onMessageHandler);
  }
}
function onMessageHandler(event) {
  var _a, _b, _c;
  const source = event.source;
  if (event.data !== null && !Array.isArray(event.data) && typeof event.data === "object") {
    if (((_a = event.data) == null ? void 0 : _a.type) === GET_COOKIE_TYPE) {
      const cookieName = (_c = (_b = event.data) == null ? void 0 : _b.data) == null ? void 0 : _c.name;
      postCookieMessage(source, cookieName);
    }
  }
}
function postUserInfoMessage(target, frameUserInfo) {
  postMessage(target, {
    type: FRAME_USER_INFO_TYPE,
    data: frameUserInfo
  });
}
const COOKIE_NAME = "x-customs-user";
function getCookieByName(name) {
  const cookies = document.cookie.split(";");
  for (const cookie of cookies) {
    if (cookie.startsWith(name + "=")) {
      const value = cookie.substring(name.length + 1);
      return value;
    }
  }
  return null;
}
function getTopCookie(name = COOKIE_NAME) {
  if (!core.isClient) return;
  if (window.top === window.self) {
    return;
  } else {
    postMessage(top, { type: GET_COOKIE_TYPE, data: { name } });
  }
}
function postCookieMessage(target, cookieName = COOKIE_NAME) {
  const cookie = getCookieByName(cookieName);
  postMessage(target, {
    type: COOKIE_TYPE,
    data: { name: cookieName, value: cookie }
  });
}
function postRefreshMessage(target) {
  postMessage(target, {
    type: FRAME_REFRESH,
    data: {}
  });
}

exports.COOKIE_NAME = COOKIE_NAME;
exports.COOKIE_TYPE = COOKIE_TYPE;
exports.FRAME_REFRESH = FRAME_REFRESH;
exports.FRAME_USER_INFO_TYPE = FRAME_USER_INFO_TYPE;
exports.GET_COOKIE_TYPE = GET_COOKIE_TYPE;
exports.addMessageListener = addMessageListener;
exports.getTopCookie = getTopCookie;
exports.postCookieMessage = postCookieMessage;
exports.postMessage = postMessage;
exports.postRefreshMessage = postRefreshMessage;
exports.postUserInfoMessage = postUserInfoMessage;
//# sourceMappingURL=index.js.map
