/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.convert;

import dm.jdbc.convert.OffRowData;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ByteUtil;
import java.io.IOException;
import java.io.Reader;

public class OffRowReaderData
extends OffRowData {
    public OffRowReaderData(Reader reader, String string, long l2) {
        super(reader, string, l2);
    }

    @Override
    public void read(ByteArrayQueue byteArrayQueue) {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArrayQueue);
        } else if (!this.readOver) {
            int n2 = READ_LEN;
            if (this.targetLength != -1L) {
                n2 = (int)(this.targetLength - (long)this.position > (long)n2 ? (long)n2 : this.targetLength - (long)this.position);
            }
            try {
                Reader reader = (Reader)this.obj;
                char[] cArray = new char[n2];
                n2 = reader.read(cArray, 0, cArray.length);
                if (n2 <= 0) {
                    this.readOver = true;
                    return;
                }
                byte[] byArray = ByteUtil.fromString(new String(cArray, 0, n2), this.encoding);
                this.position += n2;
                if (n2 < cArray.length || this.targetLength != -1L && (long)this.position == this.targetLength) {
                    this.readOver = true;
                }
                byteArrayQueue.putBytes(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                DBError.throwException(iOException.getMessage(), iOException);
            }
        }
    }

    @Override
    public byte[] readAll() {
        ByteArrayQueue byteArrayQueue = new ByteArrayQueue();
        this.read(byteArrayQueue);
        while (!this.readOver) {
            this.read(byteArrayQueue);
        }
        return byteArrayQueue.toBytes();
    }
}

