export type MessageType = 'THEME_UPDATE' | 'FONT_SCALE' | 'USER_SYNC' | string;
export interface BridgeMessage<T = unknown> {
    type: MessageType;
    payload: T;
    metadata?: {
        timestamp: number;
        source: string;
        signature?: string;
    };
}
export type SourceType = 'container' | 'subApp' | 'tab';
export type ContextType = 'iframe' | 'tab';
export interface PostMessageFn {
    (message: any, targetOrigin: string, transfer?: Transferable[]): void;
}
export declare const COOKIE_TYPE = "cookie";
export declare const GET_COOKIE_TYPE = "get-top-cookie";
export declare const FRAME_USER_INFO_TYPE = "frame-user-info";
export declare const FRAME_REFRESH = "frame-refresh";
export declare const COOKIE_NAME = "x-customs-user";
export declare const PARENT_OPEN = "parent-open";
