import { defineComponent, ref, onMounted, onUnmounted, resolveComponent, openBlock, createElementBlock, normalizeClass, unref, createElementVNode, withModifiers, renderSlot, createVNode, createCommentVNode } from 'vue';
import { ArrowDown as arrow_down_default, ArrowUp as arrow_up_default } from '../../../../svg-icons/vue/dist/index.mjs';
import '../../../hooks/index.mjs';
import { debounce } from 'lodash-es';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpStickyToolbar"
  },
  __name: "stickyToolbar",
  props: {
    selector: { type: String, required: false, default: ".el-button" }
  },
  emits: ["toggleEnd"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const bem = useNamespace("sticky");
    const props = __props;
    const wrapperDom = ref(null);
    const elDom = ref(null);
    const minHeight = ref(0);
    const maxHeight = ref(0);
    const showToggle = ref(false);
    const collapse = ref(true);
    let marginBottom = 10;
    let enableEmit = false;
    const init = async () => {
      enableEmit = false;
      if (wrapperDom.value) {
        elDom.value = wrapperDom.value.querySelector(props.selector);
        if (elDom.value != null) {
          if (getComputedStyle(elDom.value).display === "none") {
            elDom.value.style.display = "";
          }
          minHeight.value = elDom.value.offsetHeight;
          marginBottom = parseInt(getComputedStyle(elDom.value).marginBottom);
        }
        maxHeight.value = wrapperDom.value.scrollHeight - marginBottom;
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
        setTimeout(() => {
          wrapperDom.value.style.transition = "max-height linear 0.3s";
        }, 0);
      }
    };
    const resize = () => {
      enableEmit = false;
      if (elDom.value && elDom.value.offsetHeight > 0) {
        minHeight.value = elDom.value.offsetHeight;
        marginBottom = parseInt(getComputedStyle(elDom.value).marginBottom);
        maxHeight.value = wrapperDom.value.scrollHeight - marginBottom;
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const modeChangeResize = () => {
      var _a;
      (_a = wrapperDom.value) == null ? void 0 : _a.addEventListener("transitionend", resize, { once: true });
    };
    const onToggle = () => {
      enableEmit = true;
      collapse.value = !collapse.value;
      if (wrapperDom.value) {
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const emit = __emit;
    const onToggleEnd = () => {
      if (enableEmit) {
        emit("toggleEnd", collapse.value);
      }
    };
    __expose({ onToggle });
    let debounceResize = debounce(resize, 100);
    onMounted(() => {
      init();
      window.addEventListener("resize", debounceResize);
      window.addEventListener("modeChange", modeChangeResize);
    });
    onUnmounted(() => {
      window.removeEventListener("resize", debounceResize);
      window.removeEventListener("modeChange", modeChangeResize);
    });
    return (_ctx, _cache) => {
      const _component_el_button = resolveComponent("el-button");
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(bem).e("toolbar"))
        },
        [
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(bem).e("main"))
            },
            [
              createElementVNode(
                "div",
                {
                  class: normalizeClass(unref(bem).e("wrap")),
                  ref_key: "wrapperDom",
                  ref: wrapperDom,
                  onTransitionend: withModifiers(onToggleEnd, ["self"])
                },
                [
                  renderSlot(_ctx.$slots, "content")
                ],
                34
                /* CLASS, NEED_HYDRATION */
              ),
              showToggle.value ? renderSlot(_ctx.$slots, "toggle", { key: 0 }, () => [
                createVNode(_component_el_button, {
                  type: "primary",
                  icon: collapse.value ? unref(arrow_down_default) : unref(arrow_up_default),
                  onClick: onToggle,
                  class: normalizeClass(unref(bem).e("toggle"))
                }, null, 8, ["icon", "class"])
              ]) : createCommentVNode("v-if", true)
            ],
            2
            /* CLASS */
          ),
          renderSlot(_ctx.$slots, "side")
        ],
        2
        /* CLASS */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=stickyToolbar.vue2.mjs.map
