import { defineComponent, ref, provide, openBlock, createBlock, Teleport, createVNode, Transition, unref, withCtx, withDirectives, normalizeStyle, createElementVNode, normalizeClass, mergeProps, createSlots, renderSlot, createCommentVNode, vShow } from 'vue';
import { useNamespace, dialogInjectionKey, useSameTarget, ElOverlay } from 'element-plus';
import ElFocusTrap from 'element-plus/es/components/focus-trap/index';
import { dialogProps, dialogEmits } from './dialog.mjs';
import { useDialog } from './use-dialog.mjs';
import './dialogContent.vue.mjs';
import _sfc_main$1 from './dialogContent.vue2.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "cacpDialog",
    inheritAttrs: false
  },
  __name: "dialog",
  props: dialogProps,
  emits: dialogEmits,
  setup(__props, { expose: __expose }) {
    const props = __props;
    const ns = useNamespace("dialog");
    const dialogRef = ref();
    const headerRef = ref();
    const dialogContentRef = ref();
    const isMinus = ref(false);
    const {
      visible,
      titleId,
      bodyId,
      style,
      overlayDialogStyle,
      rendered,
      zIndex,
      afterEnter,
      afterLeave,
      beforeLeave,
      handleClose,
      onModalClick,
      onOpenAutoFocus,
      onCloseAutoFocus,
      onCloseRequested,
      onFocusoutPrevented
    } = useDialog(props, dialogRef);
    provide(dialogInjectionKey, {
      dialogRef,
      headerRef,
      bodyId,
      ns,
      rendered,
      style
    });
    const overlayEvent = useSameTarget(onModalClick);
    const resetPosition = () => {
      var _a;
      (_a = dialogContentRef.value) == null ? void 0 : _a.resetPosition();
    };
    const handleMinusChange = (value) => {
      isMinus.value = value;
    };
    __expose({
      visible,
      dialogContentRef,
      resetPosition
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(Teleport, {
        to: _ctx.appendTo,
        disabled: _ctx.appendTo !== "body" ? false : !_ctx.appendToBody
      }, [
        createVNode(Transition, {
          name: "dialog-fade",
          onAfterEnter: unref(afterEnter),
          onAfterLeave: unref(afterLeave),
          onBeforeLeave: unref(beforeLeave),
          persisted: ""
        }, {
          default: withCtx(() => [
            withDirectives(createVNode(unref(ElOverlay), {
              "custom-mask-event": "",
              mask: _ctx.modal && !isMinus.value,
              "overlay-class": _ctx.modalClass,
              "z-index": unref(zIndex),
              style: normalizeStyle({ "pointer-events": !_ctx.modal || isMinus.value ? "none" : "auto" })
            }, {
              default: withCtx(() => [
                createElementVNode("div", {
                  role: "dialog",
                  "aria-modal": "true",
                  "aria-label": _ctx.title || void 0,
                  "aria-labelledby": !_ctx.title ? unref(titleId) : void 0,
                  "aria-describedby": unref(bodyId),
                  class: normalizeClass(`${unref(ns).namespace.value}-overlay-dialog`),
                  style: normalizeStyle([unref(overlayDialogStyle), { "pointer-events": !_ctx.modal || isMinus.value ? "none" : "auto" }]),
                  onClick: unref(overlayEvent).onClick,
                  onMousedown: unref(overlayEvent).onMousedown,
                  onMouseup: unref(overlayEvent).onMouseup
                }, [
                  createVNode(unref(ElFocusTrap), {
                    loop: "",
                    trapped: unref(visible),
                    "focus-start-el": "container",
                    onFocusAfterTrapped: unref(onOpenAutoFocus),
                    onFocusAfterReleased: unref(onCloseAutoFocus),
                    onFocusoutPrevented: unref(onFocusoutPrevented),
                    onReleaseRequested: unref(onCloseRequested)
                  }, {
                    default: withCtx(() => [
                      unref(rendered) ? (openBlock(), createBlock(_sfc_main$1, mergeProps({
                        key: 0,
                        ref_key: "dialogContentRef",
                        ref: dialogContentRef
                      }, _ctx.$attrs, {
                        "align-center": _ctx.alignCenter,
                        "close-icon": _ctx.closeIcon,
                        draggable: _ctx.draggable,
                        resizable: _ctx.resizable,
                        overflow: _ctx.overflow,
                        fullscreen: _ctx.fullscreen,
                        center: _ctx.center,
                        "show-close": _ctx.showClose,
                        title: _ctx.title,
                        "aria-level": _ctx.headerAriaLevel,
                        onClose: unref(handleClose),
                        onMinusChange: handleMinusChange
                      }), createSlots({
                        header: withCtx(() => [
                          !_ctx.$slots.title ? renderSlot(_ctx.$slots, "header", {
                            key: 0,
                            close: unref(handleClose),
                            titleId: unref(titleId),
                            titleClass: unref(ns).e("title")
                          }) : renderSlot(_ctx.$slots, "title", { key: 1 })
                        ]),
                        default: withCtx(() => [
                          renderSlot(_ctx.$slots, "default")
                        ]),
                        _: 2
                        /* DYNAMIC */
                      }, [
                        _ctx.$slots.footer ? {
                          name: "footer",
                          fn: withCtx(() => [
                            renderSlot(_ctx.$slots, "footer")
                          ]),
                          key: "0"
                        } : void 0
                      ]), 1040, ["align-center", "close-icon", "draggable", "resizable", "overflow", "fullscreen", "center", "show-close", "title", "aria-level", "onClose"])) : createCommentVNode("v-if", true)
                    ]),
                    _: 3
                    /* FORWARDED */
                  }, 8, ["trapped", "onFocusAfterTrapped", "onFocusAfterReleased", "onFocusoutPrevented", "onReleaseRequested"])
                ], 46, ["aria-label", "aria-labelledby", "aria-describedby", "onClick", "onMousedown", "onMouseup"])
              ]),
              _: 3
              /* FORWARDED */
            }, 8, ["mask", "overlay-class", "z-index", "style"]), [
              [vShow, unref(visible)]
            ])
          ]),
          _: 3
          /* FORWARDED */
        }, 8, ["onAfterEnter", "onAfterLeave", "onBeforeLeave"])
      ], 8, ["to", "disabled"]);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=dialog.vue2.mjs.map
