import { defineComponent, resolveComponent, openBlock, createElementBlock, normalizeClass, unref, renderSlot, createElementVNode, createVNode, withCtx, createCommentVNode } from 'vue';
import '../../../hooks/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpSearchLayout"
  },
  __name: "searchLayout",
  setup(__props) {
    const bem = useNamespace("search");
    return (_ctx, _cache) => {
      const _component_el_scrollbar = resolveComponent("el-scrollbar");
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(bem).e("layout"))
        },
        [
          renderSlot(_ctx.$slots, "search"),
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(bem).e("content"))
            },
            [
              _ctx.$slots.sidebar ? (openBlock(), createElementBlock(
                "div",
                {
                  key: 0,
                  class: normalizeClass(unref(bem).e("sidebar"))
                },
                [
                  createVNode(_component_el_scrollbar, null, {
                    default: withCtx(() => [
                      renderSlot(_ctx.$slots, "sidebar")
                    ]),
                    _: 3
                    /* FORWARDED */
                  })
                ],
                2
                /* CLASS */
              )) : createCommentVNode("v-if", true),
              createElementVNode(
                "div",
                {
                  class: normalizeClass(unref(bem).e("main"))
                },
                [
                  _ctx.$slots.toolbar ? (openBlock(), createElementBlock(
                    "div",
                    {
                      key: 0,
                      class: normalizeClass(unref(bem).e("toolbar"))
                    },
                    [
                      renderSlot(_ctx.$slots, "toolbar")
                    ],
                    2
                    /* CLASS */
                  )) : createCommentVNode("v-if", true),
                  _ctx.$slots.list ? (openBlock(), createElementBlock(
                    "div",
                    {
                      key: 1,
                      class: normalizeClass(unref(bem).e("grid"))
                    },
                    [
                      renderSlot(_ctx.$slots, "list")
                    ],
                    2
                    /* CLASS */
                  )) : createCommentVNode("v-if", true),
                  _ctx.$slots.pagination ? (openBlock(), createElementBlock(
                    "div",
                    {
                      key: 2,
                      class: normalizeClass(unref(bem).e("pagination"))
                    },
                    [
                      renderSlot(_ctx.$slots, "pagination")
                    ],
                    2
                    /* CLASS */
                  )) : createCommentVNode("v-if", true),
                  renderSlot(_ctx.$slots, "default")
                ],
                2
                /* CLASS */
              )
            ],
            2
            /* CLASS */
          )
        ],
        2
        /* CLASS */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=searchLayout.vue2.mjs.map
