'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../utils/index.js');
var elementPlus = require('element-plus');
var istype = require('../../../utils/tools/istype.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpTableOperator"
  },
  __name: "TableOperator",
  props: {
    actions: { type: Array, required: false, default: () => [] },
    width: { type: Number, required: false },
    title: { type: String, required: false, default: "\u64CD\u4F5C" }
  },
  emits: ["inline-action"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const actionsWidth = vue.computed(() => {
      if (props.width) {
        return props.width;
      }
      if (props.actions.length >= 4) {
        return 312;
      }
      if (props.actions.length === 3) {
        return 238;
      }
      if (props.actions.length === 2) {
        return 168;
      }
      return 98;
    });
    function getAvailbleActions(row) {
      return props.actions.filter((action) => {
        return isEnabled(action, row);
      });
    }
    function isEnabled(action, row) {
      if (istype.isFunction(action.disabled)) {
        return !action.disabled(row);
      } else if (action.disabled) {
        return false;
      }
      return true;
    }
    function getConfirmText(confirm) {
      if (istype.isString(confirm)) {
        return confirm;
      }
      return "\u60A8\u786E\u5B9A\u8BE5\u64CD\u4F5C\uFF1F";
    }
    function onConfirmAction(action, row, rowIndex) {
      if (!isEnabled(action, row)) {
        return;
      }
      if (action.confirm) {
        elementPlus.ElMessageBox.confirm(getConfirmText(action.confirm), "\u63D0\u793A", { type: "warning", cancelButtonText: "\u53D6\u6D88", confirmButtonText: "\u786E\u5B9A" }).then(() => {
          onAction(action, row, rowIndex);
        }).catch(() => {
        });
      } else {
        onAction(action, row, rowIndex);
      }
    }
    function onAction(action, row, rowIndex) {
      if (action.onclick) {
        if (istype.isFunction(action.onclick)) {
          action.onclick(row, rowIndex);
        } else {
          emit("inline-action", action.onclick, row, rowIndex);
        }
      }
    }
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElTableColumn), {
        fixed: "right",
        label: __props.title,
        width: actionsWidth.value
      }, {
        default: vue.withCtx((scope) => [
          vue.createVNode(
            vue.unref(elementPlus.ElSpace),
            null,
            {
              default: vue.withCtx(() => [
                (vue.openBlock(true), vue.createElementBlock(
                  vue.Fragment,
                  null,
                  vue.renderList(getAvailbleActions(scope.row), (action) => {
                    return vue.openBlock(), vue.createBlock(vue.unref(elementPlus.ElLink), {
                      key: action.key,
                      type: "primary",
                      title: action.tooltip,
                      icon: action.icon,
                      onClick: ($event) => onConfirmAction(action, scope.row, scope.$index)
                    }, {
                      default: vue.withCtx(() => [
                        vue.createTextVNode(
                          vue.toDisplayString(action.text),
                          1
                          /* TEXT */
                        )
                      ]),
                      _: 2
                      /* DYNAMIC */
                    }, 1032, ["title", "icon", "onClick"]);
                  }),
                  128
                  /* KEYED_FRAGMENT */
                ))
              ]),
              _: 2
              /* DYNAMIC */
            },
            1024
            /* DYNAMIC_SLOTS */
          )
        ]),
        _: 1
        /* STABLE */
      }, 8, ["label", "width"]);
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=TableOperator.vue2.js.map
