export type HolidayFlag = 'FESTIVAL' | 'WEEKEND';
export interface AuditLogInfo {
    /** id */
    logId: string;
    /** 部门ParentId */
    parentId: string;
    /** 用户GUID */
    userId: string;
    /** 用户全路径 */
    fullPathName: string;
    /** 用户名 */
    userName: string;
    /** 关区 */
    customsCode: string;
    /** 客户端IP */
    ipAddress: string;
    /** 视角 */
    viewCode: string;
    /** 应用编码 */
    appCode: string;
    /** 应用特征码 */
    appFeatureCode: string;
    /** 业务系统日志Id */
    orgId: string;
    /** 业务ID */
    bizId: string;
    /** 环节ID */
    stepId: string;
    /** 操作时间 */
    operTime: number;
    /** 操作对象表及字段名称 */
    operDbItems: string;
    /** 操作类型编码 */
    operType: string;
    /** 操作内容 */
    operContent: string;
    /** 操作数据量 */
    operDataQty: string;
    /** 操作描述 */
    operDesc: string;
    /** 操作结果 */
    operResult: string;
    /** sm3加密数据 */
    hashCode: string;
    /** 创建日期 */
    recCreateTime: number;
}
export interface Counter {
    appCode: string;
    counterPrefix: string;
    counterValue: number;
}
export interface Holiday {
    customsCode: string;
    holidayDate: string;
    holidayName: string;
    holidayFlag: HolidayFlag;
}
