'use strict';

var shared = require('@vue/shared');
var index = require('element-plus/es/utils/index');
var index$1 = require('element-plus/es/components/tooltip/index');
var index$2 = require('element-plus/es/hooks/index');
require('../../../constants/index.js');
var event = require('../../../constants/event.js');

const autocompleteProps = index.buildProps({
  // 用来展示的字段名
  valueKey: {
    type: String,
    default: "value"
  },
  // 选中项绑定值
  modelValue: {
    type: Array,
    default: []
  },
  // 获取输入建议的防抖延时，单位为毫秒
  debounce: {
    type: Number,
    default: 300
  },
  // 下拉框出现的位置
  placement: {
    type: index.definePropType(String),
    values: [
      "top",
      "top-start",
      "top-end",
      "bottom",
      "bottom-start",
      "bottom-end"
    ],
    default: "bottom-start"
  },
  // 获取输入建议的方法，仅当输入的建议数据resolve的时候，通过调用callback(data:[])来返回它
  fetchSuggestions: {
    type: index.definePropType([Function, Array]),
    default: shared.NOOP
  },
  // 远程搜索中的返回值允许点击几个
  multiple: {
    type: Boolean,
    default: false
  },
  popperClass: {
    type: String,
    default: ""
  },
  triggerOnFocus: {
    type: Boolean,
    default: true
  },
  selectWhenUnmatched: {
    type: Boolean,
    default: false
  },
  hideLoading: {
    type: Boolean,
    default: false
  },
  teleported: index$1.useTooltipContentProps.teleported,
  highlightFirstItem: {
    type: Boolean,
    default: false
  },
  fitInputWidth: {
    type: Boolean,
    default: false
  },
  clearable: {
    type: Boolean,
    default: false
  },
  name: String,
  ...index$2.useAriaProps(["ariaLabel"])
});
const autocompleteEmits = {
  [event.UPDATE_MODEL_EVENT]: (value) => index.isArray(value),
  [event.INPUT_EVENT]: (value) => index.isString(value),
  [event.CHANGE_EVENT]: (value) => index.isString(value),
  focus: (evt) => evt instanceof FocusEvent,
  blur: (evt) => evt instanceof FocusEvent,
  clear: () => true,
  select: (item, selected) => index.isObject(item) && index.isBoolean(selected)
};

exports.autocompleteEmits = autocompleteEmits;
exports.autocompleteProps = autocompleteProps;
//# sourceMappingURL=autocomplete.js.map
