import { defineComponent, useAttrs as useAttrs$1, ref, computed, onBeforeUnmount, onMounted, openBlock, createBlock, unref, withCtx, createElementVNode, normalizeClass, normalizeStyle, createVNode, createElementBlock, renderSlot, Fragment, createCommentVNode, renderList, createTextVNode, toDisplayString, mergeProps, withKeys, withModifiers, createSlots } from 'vue';
import { debounce } from 'lodash-es';
import { onClickOutside } from '@vueuse/core';
import { Loading as loading_default, Check as check_default } from '../../../../svg-icons/vue/dist/index.mjs';
import '../../../hooks/index.mjs';
import { useAttrs, useId, ElTooltip, ElScrollbar, ElIcon, ElInput } from 'element-plus';
import '../../../utils/index.mjs';
import '../../../constants/index.mjs';
import { useFormDisabled } from 'element-plus/es/components/form/index';
import { autocompleteProps, autocompleteEmits } from './autocomplete.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import { throwError } from '../../../utils/tools/throw-error.mjs';
import { INPUT_EVENT, CHANGE_EVENT, UPDATE_MODEL_EVENT } from '../../../constants/event.mjs';

const COMPONENT_NAME = "CacpAutocomplete";
var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: COMPONENT_NAME,
    inheritAttrs: false
  },
  __name: "autoComplete",
  props: autocompleteProps,
  emits: autocompleteEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const attrs = useAttrs();
    const rawAttrs = useAttrs$1();
    const disabled = useFormDisabled();
    const ns = useNamespace("autocomplete");
    const inputRef = ref();
    const regionRef = ref();
    const popperRef = ref();
    const listboxRef = ref();
    let readonly = false;
    let ignoreFocusEvent = false;
    const queryValue = ref("");
    const selectedItems = ref(/* @__PURE__ */ new Set());
    const suggestions = ref([]);
    const highlightedIndex = ref(-1);
    const dropdownWidth = ref("");
    const activated = ref(false);
    const suggestionDisabled = ref(false);
    const loading = ref(false);
    const listboxId = useId();
    const styles = computed(() => rawAttrs.style);
    const suggestionVisible = computed(() => {
      const isValidData = suggestions.value.length > 0;
      return (isValidData || loading.value) && activated.value;
    });
    const suggestionLoading = computed(() => {
      return !props.hideLoading && loading.value;
    });
    const refInput = computed(() => {
      if (inputRef.value) {
        return Array.from(
          inputRef.value.$el.querySelectorAll("input")
        );
      }
      return [];
    });
    const onSuggestionShow = () => {
      if (suggestionVisible.value) {
        if (Array.isArray(props.modelValue)) {
          selectedItems.value = new Set(props.modelValue);
        } else {
          selectedItems.value = /* @__PURE__ */ new Set([props.modelValue]);
        }
        dropdownWidth.value = `${inputRef.value.$el.offsetWidth}px`;
      }
    };
    const onHide = () => {
      highlightedIndex.value = -1;
      selectedItems.value.clear();
    };
    const getData = async (queryString) => {
      if (suggestionDisabled.value) return;
      const cb = (suggestionList) => {
        loading.value = false;
        if (suggestionDisabled.value) return;
        if (Array.isArray(suggestionList)) {
          suggestions.value = suggestionList;
          highlightedIndex.value = props.highlightFirstItem ? 0 : -1;
        } else {
          throwError(COMPONENT_NAME, "autocomplete\u7684suggestions\u5FC5\u987B\u662F\u4E00\u4E2A\u6570\u7EC4");
        }
      };
      loading.value = true;
      if (Array.isArray(props.fetchSuggestions)) {
        cb(props.fetchSuggestions);
      } else {
        const result = await props.fetchSuggestions(queryString, cb);
        if (Array.isArray(result)) cb(result);
      }
    };
    const debounceGetData = debounce(getData, props.debounce);
    const handleInput = (value) => {
      const valuePresented = !!value;
      emit(INPUT_EVENT, value);
      suggestionDisabled.value = false;
      if (!activated.value) {
        activated.value = valuePresented;
      }
      if (!props.triggerOnFocus && !value) {
        suggestionDisabled.value = true;
        suggestions.value = [];
        return;
      }
      debounceGetData(value);
    };
    const handleMouseDown = (event) => {
      var _a;
      if (disabled.value) return;
      if (((_a = event.target) == null ? void 0 : _a.tagName) !== "INPUT" || refInput.value.includes(document.activeElement)) {
        activated.value = true;
      }
    };
    const handleChange = (value) => {
      emit(CHANGE_EVENT, value);
    };
    const handleFocus = (event) => {
      if (!ignoreFocusEvent) {
        activated.value = true;
        emit("focus", event);
        if (props.triggerOnFocus && !readonly) {
          if (queryValue.value.trim() !== "") {
            debounceGetData(String(queryValue.value));
          }
        }
      } else {
        ignoreFocusEvent = false;
      }
    };
    const handleBlur = (event) => {
      setTimeout(() => {
        var _a;
        if ((_a = popperRef.value) == null ? void 0 : _a.isFocusInsideContent()) {
          ignoreFocusEvent = true;
          return;
        }
        if (activated.value) {
          close();
        }
        emit("blur", event);
      });
    };
    const handleClear = () => {
      activated.value = false;
      emit("clear");
    };
    const handleKeyEnter = async () => {
      if (suggestionVisible.value && highlightedIndex.value >= 0 && highlightedIndex.value < suggestions.value.length) {
        handleSelect(suggestions.value[highlightedIndex.value]);
      } else if (props.selectWhenUnmatched) {
        suggestions.value = [];
        highlightedIndex.value = -1;
      }
    };
    const handleKeyEscape = (event) => {
      if (suggestionVisible.value) {
        event.preventDefault();
        event.stopPropagation();
        close();
      }
    };
    const close = () => {
      suggestions.value = [];
      activated.value = false;
    };
    const focus = () => {
      var _a;
      (_a = inputRef.value) == null ? void 0 : _a.focus();
    };
    const blur = () => {
      var _a;
      (_a = inputRef.value) == null ? void 0 : _a.blur();
    };
    const handleSelect = async (item) => {
      var _a;
      let isSelected = false;
      if (props.multiple) {
        if (selectedItems.value.has(item[props.valueKey])) {
          selectedItems.value.delete(item[props.valueKey]);
        } else {
          selectedItems.value.add(item[props.valueKey]);
          isSelected = true;
        }
        const selectedList = Array.from(selectedItems.value);
        emit(UPDATE_MODEL_EVENT, selectedList);
      } else {
        selectedItems.value.clear();
        selectedItems.value.add(item[props.valueKey]);
        emit(UPDATE_MODEL_EVENT, [item[props.valueKey]]);
        highlightedIndex.value = -1;
        (_a = inputRef.value) == null ? void 0 : _a.blur();
        isSelected = true;
        activated.value = false;
      }
      emit("select", item, isSelected);
    };
    const highlight = (index) => {
      var _a;
      if (!suggestionVisible.value || loading.value) return;
      if (index < 0) {
        highlightedIndex.value = -1;
        return;
      }
      if (index >= suggestions.value.length) {
        index = suggestions.value.length - 1;
      }
      const suggestion = regionRef.value.querySelector(
        `.${ns.be("suggestion", "wrap")}`
      );
      const suggestionList = suggestion.querySelectorAll(
        `.${ns.be("suggestion", "list")} li`
      );
      const highlightItem = suggestionList[index];
      const scrollTop = suggestion.scrollTop;
      const { offsetTop, scrollHeight } = highlightItem;
      if (offsetTop + scrollHeight > scrollTop + suggestion.clientHeight) {
        suggestion.scrollTop += scrollHeight;
      }
      if (offsetTop < scrollTop) {
        suggestion.scrollTop -= scrollHeight;
      }
      highlightedIndex.value = index;
      (_a = inputRef.value) == null ? void 0 : _a.ref.setAttribute(
        "aria-activedescendant",
        `${listboxId.value}-item-${highlightedIndex.value}`
      );
    };
    const stopHandle = onClickOutside(
      listboxRef,
      () => {
        if (suggestionVisible.value) {
          close();
          ignoreFocusEvent = false;
        }
      },
      { ignore: [regionRef] }
      //如果点击事件发生在下拉内部，不触发close
    );
    const isSelect = (item) => {
      return selectedItems.value.has(item[props.valueKey]);
    };
    onBeforeUnmount(() => {
      stopHandle == null ? void 0 : stopHandle();
    });
    onMounted(() => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
      (_b = (_a = inputRef.value) == null ? void 0 : _a.ref) == null ? void 0 : _b.setAttribute("role", "textbox");
      (_d = (_c = inputRef.value) == null ? void 0 : _c.ref) == null ? void 0 : _d.setAttribute("aria-autocomplete", "list");
      (_f = (_e = inputRef.value) == null ? void 0 : _e.ref) == null ? void 0 : _f.setAttribute("aria-contrils", "id");
      (_h = (_g = inputRef.value) == null ? void 0 : _g.ref) == null ? void 0 : _h.setAttribute(
        "aria-activedescendant",
        `${listboxId.value}-item-${highlightedIndex.value}`
      );
      readonly = ((_j = (_i = inputRef.value) == null ? void 0 : _i.ref) == null ? void 0 : _j.hasAttribute("readonly")) || false;
    });
    __expose({
      highlightedIndex,
      activated,
      loading,
      inputRef,
      popperRef,
      suggestions,
      handleSelect,
      focus,
      blur,
      close,
      highlight,
      getData
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ElTooltip), {
        ref_key: "popperRef",
        ref: popperRef,
        visible: suggestionVisible.value,
        placement: _ctx.placement,
        "fallback-placements": ["bottom-start", "top-start"],
        "popper-class": [unref(ns).e("popper"), _ctx.popperClass],
        teleported: _ctx.teleported,
        "gpu-acceleration": false,
        offset: 8,
        pure: "",
        "manual-mode": "",
        effect: "light",
        trigger: "click",
        transition: `${unref(ns).namespace.value}-zoom-in-top`,
        persostent: "",
        role: "listbox",
        onBeforeShow: onSuggestionShow,
        onHide
      }, {
        content: withCtx(() => [
          createElementVNode(
            "div",
            {
              ref_key: "regionRef",
              ref: regionRef,
              class: normalizeClass([unref(ns).b("suggestion"), unref(ns).is("loading", suggestionLoading.value)]),
              style: normalizeStyle({
                [_ctx.fitInputWidth ? "width" : "minWidth"]: dropdownWidth.value,
                outline: "none"
              }),
              role: "region"
            },
            [
              createVNode(unref(ElScrollbar), {
                id: unref(listboxId),
                tag: "ul",
                "wrap-class": unref(ns).be("suggestion", "wrap"),
                "view-class": unref(ns).be("suggestion", "list"),
                role: "listbox"
              }, {
                default: withCtx(() => [
                  suggestionLoading.value ? (openBlock(), createElementBlock("li", { key: 0 }, [
                    renderSlot(_ctx.$slots, "loading", {}, () => [
                      createVNode(unref(ElIcon), {
                        class: normalizeClass(unref(ns).is("loading"))
                      }, {
                        default: withCtx(() => [
                          createVNode(unref(loading_default))
                        ]),
                        _: 1
                        /* STABLE */
                      }, 8, ["class"])
                    ])
                  ])) : (openBlock(), createElementBlock(
                    Fragment,
                    { key: 1 },
                    [
                      createCommentVNode(` <li :class="ns.is('empty')" v-if="suggestions.length == 0">
              <slot name="empty">\u6682\u65E0\u6570\u636E</slot>
            </li> `),
                      (openBlock(true), createElementBlock(
                        Fragment,
                        null,
                        renderList(suggestions.value, (item, index) => {
                          return openBlock(), createElementBlock("li", {
                            id: `${unref(listboxId)}-item-${index}`,
                            key: index,
                            class: normalizeClass({
                              highlighted: highlightedIndex.value == index,
                              "is-selected": isSelect(item)
                            }),
                            role: "option",
                            "aria-selected": highlightedIndex.value == index,
                            onClick: ($event) => handleSelect(item)
                          }, [
                            renderSlot(_ctx.$slots, "default", { item }, () => [
                              createTextVNode(
                                toDisplayString(item[_ctx.valueKey]),
                                1
                                /* TEXT */
                              )
                            ]),
                            createVNode(unref(ElIcon), { class: "selected-icon" }, {
                              default: withCtx(() => [
                                createVNode(unref(check_default))
                              ]),
                              _: 1
                              /* STABLE */
                            })
                          ], 10, ["id", "aria-selected", "onClick"]);
                        }),
                        128
                        /* KEYED_FRAGMENT */
                      ))
                    ],
                    64
                    /* STABLE_FRAGMENT */
                  ))
                ]),
                _: 3
                /* FORWARDED */
              }, 8, ["id", "wrap-class", "view-class"])
            ],
            6
            /* CLASS, STYLE */
          )
        ]),
        default: withCtx(() => [
          createElementVNode("div", {
            ref_key: "listboxRef",
            ref: listboxRef,
            class: normalizeClass([unref(ns).b(), _ctx.$attrs.class]),
            style: normalizeStyle(styles.value),
            role: "combobox",
            "aria-haspopup": "listbox",
            "aria-expanded": suggestionVisible.value,
            "aria-owns": unref(listboxId)
          }, [
            createVNode(unref(ElInput), mergeProps({
              ref_key: "inputRef",
              ref: inputRef
            }, unref(attrs), {
              clearable: _ctx.clearable,
              disabled: unref(disabled),
              name: _ctx.name,
              modelValue: queryValue.value,
              "onUpdate:modelValue": ($event) => queryValue.value = $event,
              "aria-label": _ctx.ariaLabel,
              onInput: handleInput,
              onChange: handleChange,
              onFocus: handleFocus,
              onBlur: handleBlur,
              onClear: handleClear,
              onKeydown: [
                withKeys(withModifiers(($event) => highlight(highlightedIndex.value - 1), ["prevent"]), ["up"]),
                withKeys(withModifiers(($event) => highlight(highlightedIndex.value + 1), ["prevent"]), ["down"]),
                withKeys(handleKeyEnter, ["enter"]),
                withKeys(close, ["tab"]),
                withKeys(handleKeyEscape, ["esc"])
              ],
              onMousedown: handleMouseDown
            }), createSlots({
              _: 2
              /* DYNAMIC */
            }, [
              _ctx.$slots.prepend ? {
                name: "prepend",
                fn: withCtx(() => [
                  renderSlot(_ctx.$slots, "prepend")
                ]),
                key: "0"
              } : void 0,
              _ctx.$slots.append ? {
                name: "append",
                fn: withCtx(() => [
                  renderSlot(_ctx.$slots, "append")
                ]),
                key: "1"
              } : void 0,
              _ctx.$slots.prefix ? {
                name: "prefix",
                fn: withCtx(() => [
                  renderSlot(_ctx.$slots, "prefix")
                ]),
                key: "2"
              } : void 0,
              _ctx.$slots.suffix ? {
                name: "suffix",
                fn: withCtx(() => [
                  renderSlot(_ctx.$slots, "suffix")
                ]),
                key: "3"
              } : void 0
            ]), 1040, ["clearable", "disabled", "name", "modelValue", "onUpdate:modelValue", "aria-label", "onKeydown"])
          ], 14, ["aria-expanded", "aria-owns"])
        ]),
        _: 3
        /* FORWARDED */
      }, 8, ["visible", "placement", "popper-class", "teleported", "transition"]);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=autoComplete.vue2.mjs.map
