'use strict';

var vue = require('vue');
var core = require('@vueuse/core');
var lodashEs = require('lodash-es');
var index = require('element-plus/es/hooks/index');
require('../../../constants/index.js');
var index$2 = require('element-plus/es/utils/index');
var index$1 = require('element-plus/es/components/config-provider/index');
var event = require('../../../constants/event.js');

const useDialog = (props, targetRef) => {
  var _a;
  const instance = vue.getCurrentInstance();
  const emit = instance.emit;
  const { nextZIndex } = index.useZIndex();
  let lastPosition = "", lastLeft = "", lastTop = "";
  const titleId = index.useId();
  const bodyId = index.useId();
  const visible = vue.ref(false);
  const closed = vue.ref(false);
  const rendered = vue.ref(false);
  const zIndex = vue.ref((_a = props.zIndex) != null ? _a : nextZIndex());
  let openTimer = void 0;
  let closeTimer = void 0;
  const namespace = index$1.useGlobalConfig("namespace", index.defaultNamespace);
  const style = vue.computed(() => {
    const style2 = {};
    const varPrefix = `--${namespace.value}-dialog`;
    if (!props.fullscreen) {
      if (props.top) {
        style2[`${varPrefix}-margin-top`] = props.top;
      }
    }
    if (props.width) {
      style2[`${varPrefix}-width`] = index$2.addUnit(props.width);
    }
    if (props.height) {
      style2[`${varPrefix}-height`] = index$2.addUnit(props.height);
    }
    return style2;
  });
  const overlayDialogStyle = vue.computed(() => {
    if (props.alignCenter) {
      return { display: "flex" };
    }
    return {};
  });
  function afterEnter() {
    emit("opened");
  }
  function afterLeave() {
    emit("closed");
    emit(event.UPDATE_MODEL_EVENT, false);
    if (props.destroyOnClose) {
      rendered.value = false;
    }
  }
  function beforeLeave() {
    emit("close");
  }
  function open() {
    closeTimer == null ? void 0 : closeTimer();
    openTimer == null ? void 0 : openTimer();
    if (props.openDelay && props.openDelay > 0) {
      ;
      ({ stop: openTimer } = core.useTimeoutFn(() => doOpen(), props.openDelay));
    } else {
      doOpen();
    }
  }
  function close() {
    closeTimer == null ? void 0 : closeTimer();
    openTimer == null ? void 0 : openTimer();
    if (props.closeDelay && props.closeDelay > 0) {
      ;
      ({ stop: closeTimer } = core.useTimeoutFn(() => doClose(), props.closeDelay));
    } else {
      doClose();
    }
  }
  function handleClose() {
    function hide(shouldCancel) {
      if (shouldCancel) return;
      closed.value = true;
      visible.value = false;
    }
    if (props.beforeClose) {
      props.beforeClose(hide);
    } else {
      close();
    }
  }
  function onModalClick() {
    if (props.closeOnClickModal) {
      handleClose();
    }
  }
  function doOpen() {
    if (!index$2.isClient) return;
    visible.value = true;
    if (props.draggable) {
      vue.nextTick(() => {
        if (targetRef.value) {
          const width = targetRef.value.offsetWidth;
          const height = targetRef.value.offsetHeight;
          const winWidth = document.documentElement.clientWidth;
          const winHeight = document.documentElement.clientHeight;
          targetRef.value.style.left = (winWidth - width) / 2 + "px";
          if (props.alignCenter) {
            targetRef.value.style.top = Math.max(0, (winHeight - height) / 2) + "px";
          }
        }
      });
    }
  }
  function doClose() {
    visible.value = false;
  }
  function onOpenAutoFocus() {
    emit("openAutoFocus");
  }
  function onCloseAutoFocus() {
    emit("closeAutoFocus");
  }
  function onFocusoutPrevented(event) {
    var _a2;
    if (((_a2 = event.detail) == null ? void 0 : _a2.focusReason) === "pointer") {
      event.preventDefault();
    }
  }
  if (props.lockScroll) {
    index.useLockscreen(visible);
  }
  function onCloseRequested() {
    if (props.closeOnPressEscape) {
      handleClose();
    }
  }
  vue.watch(
    () => props.modelValue,
    (val) => {
      if (val) {
        closed.value = false;
        open();
        rendered.value = true;
        zIndex.value = lodashEs.isUndefined(props.zIndex) ? nextZIndex() : zIndex.value++;
        vue.nextTick(() => {
          emit("open");
          if (targetRef.value) {
            targetRef.value.scrollTop = 0;
          }
        });
      } else {
        if (visible.value) {
          close();
        }
      }
    }
  );
  vue.watch(
    () => props.fullscreen,
    (val) => {
      if (!targetRef.value) return;
      if (val) {
        if (props.draggable) {
          lastPosition = targetRef.value.style.transform;
          targetRef.value.style.transform = "";
          lastLeft = targetRef.value.style.left;
          lastTop = targetRef.value.style.top;
          targetRef.value.style.left = "";
          targetRef.value.style.top = "";
        }
      } else {
        if (props.draggable) {
          targetRef.value.style.transform = lastPosition;
          targetRef.value.style.left = lastLeft;
          targetRef.value.style.top = lastTop;
        }
      }
    }
  );
  vue.onMounted(() => {
    if (props.modelValue) {
      visible.value = true;
      rendered.value = true;
      open();
    }
  });
  return {
    afterEnter,
    afterLeave,
    beforeLeave,
    handleClose,
    onModalClick,
    close,
    doClose,
    onOpenAutoFocus,
    onCloseAutoFocus,
    onCloseRequested,
    onFocusoutPrevented,
    titleId,
    bodyId,
    closed,
    style,
    overlayDialogStyle,
    rendered,
    visible,
    zIndex
  };
};

exports.useDialog = useDialog;
//# sourceMappingURL=use-dialog.js.map
