'use strict';

var vue = require('vue');

function useComplexTable(config) {
  const tableData = vue.ref([]);
  const tablePagination = vue.reactive({
    visible: false,
    currentPage: 1,
    pageSize: config.SERVICE_PAGESIZE,
    hideOnSinglePage: false
  });
  const setData = (data) => {
    tableData.value = data != null ? data : [];
  };
  const setPagination = (pageData) => {
    if (pageData) {
      tableData.value = pageData.list;
      Object.assign(tablePagination, {
        visible: true,
        total: pageData.total,
        currentPage: pageData.pageNum,
        pageSize: pageData.pageSize,
        hideOnSinglePage: false
      });
    } else {
      tableData.value = [];
      Object.assign(tablePagination, {
        visible: true,
        total: 0,
        currentPage: 1,
        hideOnSinglePage: true
      });
    }
  };
  const setPageIndex = (pageIndex) => {
    Object.assign(tablePagination, {
      currentPage: pageIndex
    });
  };
  const setPageSizes = (pageSize) => {
    Object.assign(tablePagination, {
      currentPage: 1,
      pageSize
    });
  };
  return {
    tableData,
    tablePagination,
    setData,
    setPagination,
    setPageIndex,
    setPageSizes
  };
}

exports.useComplexTable = useComplexTable;
//# sourceMappingURL=index.js.map
