import { defineComponent, reactive, resolveComponent, openBlock, createElementBlock, normalizeClass, unref, createElementVNode, renderSlot, toDisplayString, createVNode, withCtx, createBlock, resolveDynamicComponent, withDirectives, withModifiers, vShow } from 'vue';
import { ArrowDown as arrow_down_default, ArrowUp as arrow_up_default } from '../../../../svg-icons/vue/dist/index.mjs';
import '../../../hooks/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpCollapseContainer"
  },
  __name: "collapseContainer",
  props: {
    collapse: { type: Boolean, required: false, default: false },
    title: { type: String, required: false, default: "" }
  },
  emits: ["toggleEnd"],
  setup(__props, { emit: __emit }) {
    const bem = useNamespace("collapse");
    const emit = __emit;
    const props = __props;
    const state = reactive({
      isCollapse: props.collapse
    });
    function toggle() {
      state.isCollapse = !state.isCollapse;
    }
    const onToggleEnd = () => {
      emit("toggleEnd", state.isCollapse);
    };
    return (_ctx, _cache) => {
      const _component_el_icon = resolveComponent("el-icon");
      const _component_el_collapse_transition = resolveComponent("el-collapse-transition");
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(bem).e("container"))
        },
        [
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(bem).e("header"))
            },
            [
              renderSlot(_ctx.$slots, "title", {}, () => [
                createElementVNode(
                  "div",
                  {
                    class: normalizeClass(unref(bem).e("title"))
                  },
                  toDisplayString(__props.title),
                  3
                  /* TEXT, CLASS */
                )
              ]),
              createVNode(_component_el_icon, {
                class: normalizeClass(unref(bem).em("header", "arrow")),
                onClick: toggle
              }, {
                default: withCtx(() => [
                  (openBlock(), createBlock(resolveDynamicComponent(state.isCollapse ? unref(arrow_down_default) : unref(arrow_up_default))))
                ]),
                _: 1
                /* STABLE */
              }, 8, ["class"])
            ],
            2
            /* CLASS */
          ),
          createVNode(_component_el_collapse_transition, null, {
            default: withCtx(() => [
              withDirectives(createElementVNode(
                "div",
                {
                  class: normalizeClass(unref(bem).e("content")),
                  onTransitionend: withModifiers(onToggleEnd, ["self"])
                },
                [
                  renderSlot(_ctx.$slots, "content")
                ],
                34
                /* CLASS, NEED_HYDRATION */
              ), [
                [vShow, !state.isCollapse]
              ])
            ]),
            _: 3
            /* FORWARDED */
          })
        ],
        2
        /* CLASS */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=collapseContainer.vue2.mjs.map
