import { getCurrentInstance, ref, computed, nextTick, watch, onMounted } from 'vue';
import { useTimeoutFn } from '@vueuse/core';
import { isUndefined } from 'lodash-es';
import { useZIndex, useId, defaultNamespace, useLockscreen } from 'element-plus/es/hooks/index';
import '../../../constants/index.mjs';
import { addUnit, isClient } from 'element-plus/es/utils/index';
import { useGlobalConfig } from 'element-plus/es/components/config-provider/index';
import { UPDATE_MODEL_EVENT } from '../../../constants/event.mjs';

const useDialog = (props, targetRef) => {
  var _a;
  const instance = getCurrentInstance();
  const emit = instance.emit;
  const { nextZIndex } = useZIndex();
  let lastPosition = "", lastLeft = "", lastTop = "";
  const titleId = useId();
  const bodyId = useId();
  const visible = ref(false);
  const closed = ref(false);
  const rendered = ref(false);
  const zIndex = ref((_a = props.zIndex) != null ? _a : nextZIndex());
  let openTimer = void 0;
  let closeTimer = void 0;
  const namespace = useGlobalConfig("namespace", defaultNamespace);
  const style = computed(() => {
    const style2 = {};
    const varPrefix = `--${namespace.value}-dialog`;
    if (!props.fullscreen) {
      if (props.top) {
        style2[`${varPrefix}-margin-top`] = props.top;
      }
    }
    if (props.width) {
      style2[`${varPrefix}-width`] = addUnit(props.width);
    }
    if (props.height) {
      style2[`${varPrefix}-height`] = addUnit(props.height);
    }
    return style2;
  });
  const overlayDialogStyle = computed(() => {
    if (props.alignCenter) {
      return { display: "flex" };
    }
    return {};
  });
  function afterEnter() {
    emit("opened");
  }
  function afterLeave() {
    emit("closed");
    emit(UPDATE_MODEL_EVENT, false);
    if (props.destroyOnClose) {
      rendered.value = false;
    }
  }
  function beforeLeave() {
    emit("close");
  }
  function open() {
    closeTimer == null ? void 0 : closeTimer();
    openTimer == null ? void 0 : openTimer();
    if (props.openDelay && props.openDelay > 0) {
      ;
      ({ stop: openTimer } = useTimeoutFn(() => doOpen(), props.openDelay));
    } else {
      doOpen();
    }
  }
  function close() {
    closeTimer == null ? void 0 : closeTimer();
    openTimer == null ? void 0 : openTimer();
    if (props.closeDelay && props.closeDelay > 0) {
      ;
      ({ stop: closeTimer } = useTimeoutFn(() => doClose(), props.closeDelay));
    } else {
      doClose();
    }
  }
  function handleClose() {
    function hide(shouldCancel) {
      if (shouldCancel) return;
      closed.value = true;
      visible.value = false;
    }
    if (props.beforeClose) {
      props.beforeClose(hide);
    } else {
      close();
    }
  }
  function onModalClick() {
    if (props.closeOnClickModal) {
      handleClose();
    }
  }
  function doOpen() {
    if (!isClient) return;
    visible.value = true;
    if (props.draggable) {
      nextTick(() => {
        if (targetRef.value) {
          const width = targetRef.value.offsetWidth;
          const height = targetRef.value.offsetHeight;
          const winWidth = document.documentElement.clientWidth;
          const winHeight = document.documentElement.clientHeight;
          targetRef.value.style.left = (winWidth - width) / 2 + "px";
          if (props.alignCenter) {
            targetRef.value.style.top = Math.max(0, (winHeight - height) / 2) + "px";
          }
        }
      });
    }
  }
  function doClose() {
    visible.value = false;
  }
  function onOpenAutoFocus() {
    emit("openAutoFocus");
  }
  function onCloseAutoFocus() {
    emit("closeAutoFocus");
  }
  function onFocusoutPrevented(event) {
    var _a2;
    if (((_a2 = event.detail) == null ? void 0 : _a2.focusReason) === "pointer") {
      event.preventDefault();
    }
  }
  if (props.lockScroll) {
    useLockscreen(visible);
  }
  function onCloseRequested() {
    if (props.closeOnPressEscape) {
      handleClose();
    }
  }
  watch(
    () => props.modelValue,
    (val) => {
      if (val) {
        closed.value = false;
        open();
        rendered.value = true;
        zIndex.value = isUndefined(props.zIndex) ? nextZIndex() : zIndex.value++;
        nextTick(() => {
          emit("open");
          if (targetRef.value) {
            targetRef.value.scrollTop = 0;
          }
        });
      } else {
        if (visible.value) {
          close();
        }
      }
    }
  );
  watch(
    () => props.fullscreen,
    (val) => {
      if (!targetRef.value) return;
      if (val) {
        if (props.draggable) {
          lastPosition = targetRef.value.style.transform;
          targetRef.value.style.transform = "";
          lastLeft = targetRef.value.style.left;
          lastTop = targetRef.value.style.top;
          targetRef.value.style.left = "";
          targetRef.value.style.top = "";
        }
      } else {
        if (props.draggable) {
          targetRef.value.style.transform = lastPosition;
          targetRef.value.style.left = lastLeft;
          targetRef.value.style.top = lastTop;
        }
      }
    }
  );
  onMounted(() => {
    if (props.modelValue) {
      visible.value = true;
      rendered.value = true;
      open();
    }
  });
  return {
    afterEnter,
    afterLeave,
    beforeLeave,
    handleClose,
    onModalClick,
    close,
    doClose,
    onOpenAutoFocus,
    onCloseAutoFocus,
    onCloseRequested,
    onFocusoutPrevented,
    titleId,
    bodyId,
    closed,
    style,
    overlayDialogStyle,
    rendered,
    visible,
    zIndex
  };
};

export { useDialog };
//# sourceMappingURL=use-dialog.mjs.map
