import { isClient } from '@vueuse/core';

const localStorageKey = "standardAndCareMode";
function initMode() {
  if (isClient) {
    const mode = localStorage.getItem(localStorageKey) || "";
    if (mode) {
      document.documentElement.classList.add(mode);
    }
    window.addEventListener("storage", onStorageHandler);
    window.addEventListener("message", onMessageHandler);
    window.addEventListener(
      "beforeunload",
      () => {
        window.removeEventListener("storage", onStorageHandler);
        window.removeEventListener("message", onMessageHandler);
      },
      { once: true }
    );
  }
}
function switchStandardAndCareMode(mode, oldMode) {
  var _a;
  if (isClient) {
    const _oldMode = oldMode || localStorage.getItem(localStorageKey) || "";
    if (_oldMode) {
      document.documentElement.classList.remove(_oldMode);
    }
    if (mode.trim() === "") {
      document.documentElement.classList.add(mode);
    }
    localStorage.setItem(localStorageKey, mode);
    dispatchModeChange();
    if (window.top == window.self) {
      const iframes = document.getElementsByTagName("iframe");
      for (let i = 0; i < iframes.length; i++) {
        const iframe = iframes[i];
        (_a = iframe.contentWindow) == null ? void 0 : _a.postMessage(
          { type: "changeStandardAndCareMode", mode, oldMode: _oldMode },
          "*"
        );
      }
    }
  }
}
function onMessageHandler(event) {
  var _a;
  if (event.data !== null && !Array.isArray(event.data) && typeof event.data === "object") {
    if (((_a = event.data) == null ? void 0 : _a.type) === "changeStandardAndCareMode") {
      switchStandardAndCareMode(event.data.mode, event.data.oldMode);
    }
  }
}
function onStorageHandler(event) {
  if (event.key == localStorageKey) {
    if (event.oldValue == event.newValue) return;
    if (event.oldValue) {
      document.documentElement.classList.remove(event.oldValue);
    }
    if (event.newValue) {
      document.documentElement.classList.add(event.newValue);
    }
    dispatchModeChange();
  }
}
function dispatchModeChange() {
  const event = new Event("modeChange");
  window.dispatchEvent(event);
}
const CacpSwitchMode = {
  install(app) {
    initMode();
    app.config.globalProperties.$switchMode = switchStandardAndCareMode;
  }
};

export { CacpSwitchMode, CacpSwitchMode as default, initMode, switchStandardAndCareMode };
//# sourceMappingURL=index.mjs.map
