import { defineComponent, ref, computed, nextTick, onMounted, onBeforeUnmount, openBlock, createElementBlock, normalizeClass, unref, normalizeStyle, Fragment, renderList, createBlock, withCtx, createVNode, createTextVNode, toDisplayString, createCommentVNode } from 'vue';
import { debounce } from 'lodash-es';
import '../../../hooks/index.mjs';
import '../../../utils/index.mjs';
import { ElMessageBox, ElDropdown, ElDropdownMenu, ElDropdownItem, ElButton, ElIcon } from 'element-plus';
import { ArrowDown as arrow_down_default } from '../../../../svg-icons/vue/dist/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import { isString, isFunction } from '../../../utils/tools/istype.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpButtonGroup"
  },
  __name: "buttonGroup",
  props: {
    actions: { type: Array, required: true, default: () => [] },
    moreButtonText: { type: String, required: false, default: "\u66F4\u591A" },
    buttonType: { required: false, default: "primary" },
    plain: { type: Boolean, required: false, default: false },
    space: { type: Number, required: false, default: 12 },
    rows: { type: Array, required: false, default: () => [] }
  },
  emits: ["command"],
  setup(__props, { emit: __emit }) {
    const bem = useNamespace("button");
    const props = __props;
    const emit = __emit;
    const pCur = ref(-1);
    const visibleButtons = computed(() => {
      if (pCur.value > 0) {
        return props.actions.slice(0, pCur.value);
      } else {
        return props.actions;
      }
    });
    const moreButtons = computed(() => {
      if (pCur.value > 0) {
        let temp = [];
        let res = props.actions.slice(pCur.value);
        for (let i = 0; i < res.length; i++) {
          if (res[i].children != void 0 && res[i].children.length > 0) {
            temp.push(...res[i].children);
          } else {
            temp.push(res[i]);
          }
        }
        return temp;
      } else {
        return [];
      }
    });
    const popperOptions = {
      modifiers: [
        {
          name: "offset",
          options: {
            offset: [0, 7]
            // 水平偏移0，垂直偏移10像素
          }
        }
      ]
    };
    let resizeObsever;
    const groupHeight = ref(28);
    const groupRef = ref(null);
    let btnSizes = [];
    function getButtonSize() {
      let group = groupRef == null ? void 0 : groupRef.value;
      let space = props.space;
      if (!group) return;
      if (btnSizes.length > 0) {
        btnSizes = [];
      }
      let buttons = group.querySelectorAll(".el-button");
      if (buttons && buttons.length > 0) {
        groupHeight.value = buttons[0].offsetHeight;
        let left = 0;
        for (let i = 0; i < buttons.length; i++) {
          left += buttons[i].offsetWidth + space;
          btnSizes.push(left);
        }
      }
    }
    function getContainerWidth() {
      let group = groupRef == null ? void 0 : groupRef.value;
      if (!group) return null;
      return group.offsetWidth;
    }
    function reBuild() {
      let width = getContainerWidth();
      if (width) {
        let cur = -1;
        for (let i = 0; i < btnSizes.length; i++) {
          if (btnSizes[i] - width > props.space) {
            cur = i - 1;
            break;
          }
          cur = -1;
        }
        pCur.value = cur;
      }
    }
    function modeChangeResize() {
      var _a;
      (_a = groupRef.value) == null ? void 0 : _a.addEventListener(
        "transitionend",
        () => {
          pCur.value = -1;
          nextTick(() => {
            getButtonSize();
            reBuild();
          });
        },
        { once: true }
      );
    }
    function getConfirmText(confirm) {
      if (isString(confirm)) {
        return confirm;
      }
      return "\u60A8\u786E\u5B9A\u8BE5\u64CD\u4F5C\uFF1F";
    }
    function getActionEnabled(action) {
      if (action.disabled) return false;
      if (!action.limit || action.limit === "none") {
        return true;
      }
      if (action.limit === "one" && props.rows.length === 1) {
        return true;
      }
      if (action.limit === "more" && props.rows.length > 0) {
        return true;
      }
      return false;
    }
    function onConfirmAction(action) {
      if (action.confirm) {
        ElMessageBox.confirm(getConfirmText(action.confirm), "\u63D0\u793A", {
          type: "warning",
          cancelButtonText: "\u53D6\u6D88",
          confirmButtonText: "\u786E\u5B9A"
        }).then(() => {
          onAction(action);
        }).catch(() => {
        });
      } else {
        onAction(action);
      }
    }
    function onAction(action) {
      const rows = action.limit === "one" ? props.rows[0] : props.rows;
      if (action.onclick) {
        if (isFunction(action.onclick)) {
          action.onclick(rows);
        } else {
          emit("command", action.onclick, rows);
        }
      }
    }
    const reCalcBtnSize = debounce(function() {
      if (groupHeight.value > 0) {
        return;
      }
      getButtonSize();
    }, 100);
    onMounted(() => {
      nextTick(() => {
        requestAnimationFrame(() => {
          getButtonSize();
          reBuild();
        });
      });
      if ((groupRef == null ? void 0 : groupRef.value) && ResizeObserver) {
        resizeObsever = new ResizeObserver(reCalcBtnSize);
        resizeObsever.observe(groupRef == null ? void 0 : groupRef.value);
      }
      window.addEventListener("resize", reBuild);
      window.addEventListener("modeChange", modeChangeResize);
    });
    onBeforeUnmount(() => {
      window.removeEventListener("resize", reBuild);
      window.removeEventListener("modeChange", modeChangeResize);
      resizeObsever == null ? void 0 : resizeObsever.disconnect();
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(bem).e("group")),
          ref_key: "groupRef",
          ref: groupRef,
          style: normalizeStyle({ height: groupHeight.value + "px" })
        },
        [
          (openBlock(true), createElementBlock(
            Fragment,
            null,
            renderList(visibleButtons.value, (item) => {
              return openBlock(), createElementBlock(
                Fragment,
                {
                  key: item.key
                },
                [
                  item.children != null && item.children.length > 0 ? (openBlock(), createBlock(unref(ElDropdown), {
                    key: 0,
                    "popper-options": popperOptions,
                    "popper-class": unref(bem).em("group", "popper"),
                    "max-heighgt": "280px",
                    placement: "bottom-start"
                  }, {
                    dropdown: withCtx(() => [
                      createVNode(
                        unref(ElDropdownMenu),
                        null,
                        {
                          default: withCtx(() => [
                            (openBlock(true), createElementBlock(
                              Fragment,
                              null,
                              renderList(item.children, (child, index) => {
                                return openBlock(), createBlock(unref(ElDropdownItem), {
                                  key: index,
                                  disabled: !getActionEnabled(child),
                                  icon: child.icon,
                                  onClick: ($event) => onConfirmAction(child)
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(
                                      toDisplayString(child.text),
                                      1
                                      /* TEXT */
                                    )
                                  ]),
                                  _: 2
                                  /* DYNAMIC */
                                }, 1032, ["disabled", "icon", "onClick"]);
                              }),
                              128
                              /* KEYED_FRAGMENT */
                            ))
                          ]),
                          _: 2
                          /* DYNAMIC */
                        },
                        1024
                        /* DYNAMIC_SLOTS */
                      )
                    ]),
                    default: withCtx(() => [
                      createVNode(unref(ElButton), {
                        icon: item.icon,
                        disabled: !getActionEnabled(item),
                        type: item.type,
                        plain: item.plain,
                        title: item.tooltip
                      }, {
                        default: withCtx(() => [
                          item.text ? (openBlock(), createElementBlock(
                            Fragment,
                            { key: 0 },
                            [
                              createTextVNode(
                                toDisplayString(item.text),
                                1
                                /* TEXT */
                              )
                            ],
                            64
                            /* STABLE_FRAGMENT */
                          )) : createCommentVNode("v-if", true),
                          createVNode(unref(ElIcon), { class: "el-icon--right" }, {
                            default: withCtx(() => [
                              createVNode(unref(arrow_down_default))
                            ]),
                            _: 1
                            /* STABLE */
                          })
                        ]),
                        _: 2
                        /* DYNAMIC */
                      }, 1032, ["icon", "disabled", "type", "plain", "title"])
                    ]),
                    _: 2
                    /* DYNAMIC */
                  }, 1032, ["popper-class"])) : (openBlock(), createBlock(unref(ElButton), {
                    key: 1,
                    icon: item.icon,
                    disabled: !getActionEnabled(item),
                    type: item.type,
                    plain: item.plain,
                    title: item.tooltip,
                    onClick: ($event) => onConfirmAction(item)
                  }, {
                    default: withCtx(() => [
                      item.text ? (openBlock(), createElementBlock(
                        Fragment,
                        { key: 0 },
                        [
                          createTextVNode(
                            toDisplayString(item.text),
                            1
                            /* TEXT */
                          )
                        ],
                        64
                        /* STABLE_FRAGMENT */
                      )) : createCommentVNode("v-if", true)
                    ]),
                    _: 2
                    /* DYNAMIC */
                  }, 1032, ["icon", "disabled", "type", "plain", "title", "onClick"]))
                ],
                64
                /* STABLE_FRAGMENT */
              );
            }),
            128
            /* KEYED_FRAGMENT */
          )),
          moreButtons.value.length > 0 ? (openBlock(), createBlock(unref(ElDropdown), {
            key: 0,
            "popper-options": popperOptions,
            "popper-class": unref(bem).em("group", "popper"),
            "max-heighgt": "280px",
            placement: "bottom-start"
          }, {
            dropdown: withCtx(() => [
              createVNode(unref(ElDropdownMenu), null, {
                default: withCtx(() => [
                  (openBlock(true), createElementBlock(
                    Fragment,
                    null,
                    renderList(moreButtons.value, (child, index) => {
                      return openBlock(), createBlock(unref(ElDropdownItem), {
                        key: index,
                        disabled: !getActionEnabled(child),
                        icon: child.icon,
                        onClick: ($event) => onConfirmAction(child)
                      }, {
                        default: withCtx(() => [
                          createTextVNode(
                            toDisplayString(child.text),
                            1
                            /* TEXT */
                          )
                        ]),
                        _: 2
                        /* DYNAMIC */
                      }, 1032, ["disabled", "icon", "onClick"]);
                    }),
                    128
                    /* KEYED_FRAGMENT */
                  ))
                ]),
                _: 1
                /* STABLE */
              })
            ]),
            default: withCtx(() => [
              createVNode(unref(ElButton), {
                type: __props.buttonType,
                plain: __props.plain
              }, {
                default: withCtx(() => [
                  createTextVNode(
                    toDisplayString(__props.moreButtonText),
                    1
                    /* TEXT */
                  ),
                  createVNode(unref(ElIcon), { class: "el-icon--right" }, {
                    default: withCtx(() => [
                      createVNode(unref(arrow_down_default))
                    ]),
                    _: 1
                    /* STABLE */
                  })
                ]),
                _: 1
                /* STABLE */
              }, 8, ["type", "plain"])
            ]),
            _: 1
            /* STABLE */
          }, 8, ["popper-class"])) : createCommentVNode("v-if", true)
        ],
        6
        /* CLASS, STYLE */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=buttonGroup.vue2.mjs.map
