import '../index.mjs';
import { defaultNamespace } from '../use-namespace/index.mjs';

function setTheme(theme) {
  if (theme) {
    if (theme.elderMode) {
      document.documentElement.classList.add(`${defaultNamespace}-caremode`);
    } else {
      document.documentElement.classList.remove(`${defaultNamespace}-caremode`);
    }
    if (theme.themeCode !== "default" && theme.themeCode !== "") {
      const themePerfix = defaultNamespace + "-theme-";
      const classList = Array.from(document.documentElement.classList);
      classList.forEach((cls) => {
        if (cls.startsWith(themePerfix)) {
          document.documentElement.classList.remove(cls);
        }
      });
      document.documentElement.classList.add(themePerfix + theme.themeCode);
      loadCss(`/static-resource/theme/skin/${theme.themeCode}/theme-index.css`);
    } else {
      const themePerfix = defaultNamespace + "-theme-";
      const classList = Array.from(document.documentElement.classList);
      classList.forEach((cls) => {
        if (cls.startsWith(themePerfix)) {
          document.documentElement.classList.remove(cls);
        }
      });
    }
  }
}
function loadCss(url) {
  const linkId = "themeCss";
  if (!document.getElementById(linkId)) {
    const linkEl = document.createElement("link");
    linkEl.rel = "stylesheet";
    linkEl.href = url;
    linkEl.id = linkId;
    document.head.appendChild(linkEl);
  }
}

export { setTheme };
//# sourceMappingURL=index.mjs.map
