export type BizTraceStatus = 'START' | 'RUNNING' | 'COMPLETE';
export type BizTraceStepType = 'FLOW' | 'START' | 'COMPLETE';
export interface BizTraceInfo {
    recordId: string;
    appCode: string;
    traceCode: string;
    bizId: string;
    stepCode: string;
    parentId: string;
    userId: string;
    userName: string;
    userPath: string;
    results: string;
    comments: string;
    createTime: string;
    completedTime: string;
}
export interface BizTraceDefinitionInfo {
    appCode: string;
    traceCode: string;
    traceName: string;
    includeUser: boolean;
    useService: boolean;
    traceDescription: string;
    stepList: Array<BizTraceStepDefinitionInfo>;
}
export interface BizTraceStepDefinitionInfo {
    appCode: string;
    traceCode: string;
    stepCode: string;
    stepName: string;
    stepType: BizTraceStepType;
    stepDescription: string;
}
export interface BizTraceRuntimeInfo {
    traceId: string;
    appCode: string;
    traceCode: string;
    bizId: string;
    parentId: string;
    userId: string;
    userName: string;
    userPath: string;
    createTime: string;
    completedTime: string;
    currStep: string;
    currStatus: BizTraceStatus;
    stepList: Array<BizTraceStepRuntimeInfo>;
}
export interface BizTraceStepRuntimeInfo {
    stepId: string;
    traceId: string;
    stepCode: string;
    stepType: BizTraceStepType;
    parentId: string;
    userId: string;
    userName: string;
    userPath: string;
    results: string;
    comments: string;
    createTime: string;
    completedTime: string;
    userList: Array<BizTraceStepUserRuntimeInfo>;
}
export interface BizTraceStepUserRuntimeInfo {
    stepId: string;
    traceId: string;
    parentId: string;
    userId: string;
    userName: string;
    userPath: string;
    results: string;
    comments: string;
    processTime: string;
}
