import { Awaitable } from 'element-plus/es/utils/index';
import type { ExtractPropTypes } from 'vue';
import type Autocomplete from './autoComplete.vue';
import { Placement } from 'element-plus/es/components/popper/index';
export type AutocompleteData = Record<string, any>[];
export type AutocompleteFetchSuggestionCallback = (data: AutocompleteData) => void;
export type AutocompleteFetchSuggestion = ((queryString: string, cb: AutocompleteFetchSuggestionCallback) => Awaitable<AutocompleteData> | void) | AutocompleteData;
export declare const autocompleteProps: {
    readonly ariaLabel: StringConstructor;
    readonly valueKey: import("element-plus/es/utils/index.js").EpPropFinalized<StringConstructor, unknown, unknown, "value", boolean>;
    readonly modelValue: import("element-plus/es/utils/index.js").EpPropFinalized<{
        (arrayLength: number): (string | number)[];
        (...items: (string | number)[]): (string | number)[];
        new (arrayLength: number): (string | number)[];
        new (...items: (string | number)[]): (string | number)[];
        isArray(arg: any): arg is any[];
        readonly prototype: any[];
        from<T>(arrayLike: ArrayLike<T>): T[];
        from<T, U>(arrayLike: ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
        from<T>(iterable: Iterable<T> | ArrayLike<T>): T[];
        from<T, U>(iterable: Iterable<T> | ArrayLike<T>, mapfn: (v: T, k: number) => U, thisArg?: any): U[];
        of<T>(...items: T[]): T[];
        fromAsync<T>(iterableOrArrayLike: AsyncIterable<T> | Iterable<T | PromiseLike<T>> | ArrayLike<T | PromiseLike<T>>): Promise<T[]>;
        fromAsync<T, U>(iterableOrArrayLike: AsyncIterable<T> | Iterable<T> | ArrayLike<T>, mapFn: (value: Awaited<T>) => U, thisArg?: any): Promise<Awaited<U>[]>;
        readonly [Symbol.species]: ArrayConstructor;
    }, unknown, unknown, readonly [], boolean>;
    readonly debounce: import("element-plus/es/utils/index.js").EpPropFinalized<NumberConstructor, unknown, unknown, 300, boolean>;
    readonly placement: import("element-plus/es/utils/index.js").EpPropFinalized<(new (...args: any[]) => "bottom" | "left" | "right" | "top" | "auto" | "auto-start" | "auto-end" | "top-start" | "top-end" | "bottom-start" | "bottom-end" | "right-start" | "right-end" | "left-start" | "left-end") | (() => Placement) | (((new (...args: any[]) => "bottom" | "left" | "right" | "top" | "auto" | "auto-start" | "auto-end" | "top-start" | "top-end" | "bottom-start" | "bottom-end" | "right-start" | "right-end" | "left-start" | "left-end") | (() => Placement)) | null)[], "bottom" | "top" | "top-start" | "top-end" | "bottom-start" | "bottom-end", unknown, "bottom-start", boolean>;
    readonly fetchSuggestions: import("element-plus/es/utils/index.js").EpPropFinalized<(new (...args: any[]) => AutocompleteData | ((queryString: string, cb: AutocompleteFetchSuggestionCallback) => Awaitable<AutocompleteData> | void)) | (() => AutocompleteFetchSuggestion) | (((new (...args: any[]) => AutocompleteData | ((queryString: string, cb: AutocompleteFetchSuggestionCallback) => Awaitable<AutocompleteData> | void)) | (() => AutocompleteFetchSuggestion)) | null)[], unknown, unknown, () => void, boolean>;
    readonly multiple: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, false, boolean>;
    readonly popperClass: import("element-plus/es/utils/index.js").EpPropFinalized<StringConstructor, unknown, unknown, "", boolean>;
    readonly triggerOnFocus: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, true, boolean>;
    readonly selectWhenUnmatched: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, false, boolean>;
    readonly hideLoading: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, false, boolean>;
    readonly teleported: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, true, boolean>;
    readonly highlightFirstItem: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, false, boolean>;
    readonly fitInputWidth: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, false, boolean>;
    readonly clearable: import("element-plus/es/utils/index.js").EpPropFinalized<BooleanConstructor, unknown, unknown, false, boolean>;
    readonly name: StringConstructor;
};
export type AutocompleteProps = ExtractPropTypes<typeof autocompleteProps>;
export declare const autocompleteEmits: {
    "update:modelValue": (value: Array<string | number>) => boolean;
    input: (value: string) => boolean;
    change: (value: string) => boolean;
    focus: (evt: FocusEvent) => boolean;
    blur: (evt: FocusEvent) => boolean;
    clear: () => boolean;
    select: (item: Record<string, any>, selected: boolean) => boolean;
};
export type AutocompleteEmits = typeof autocompleteEmits;
export type AutocompleteInstance = InstanceType<typeof Autocomplete>;
