export declare const defaultNamespace = "cacp";
/**
 * 用于创建和管理BEM类名的工具函数
 * @param {string} block 块名
 * @returns 返回一个对象，包含用于创建BEM类名的各种方法
 */
export declare const useNamespace: (block: string) => {
    namespace: import("vue").ComputedRef<string>;
    b: (blockSuffix?: string) => string;
    e: (element?: string) => string;
    m: (modifier?: string) => string;
    be: (blockSuffix?: string, element?: string) => string;
    em: (element?: string, modifier?: string) => string;
    bm: (blockSuffix?: string, modifier?: string) => string;
    bem: (blockSuffix?: string, element?: string, modifier?: string) => string;
    is: {
        (name: string, state: boolean | undefined): string;
        (name: string): string;
    };
};
