'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var elementPlus = require('element-plus');
var ElFocusTrap = require('element-plus/es/components/focus-trap/index');
var dialog = require('./dialog.js');
var useDialog = require('./use-dialog.js');
require('./dialogContent.vue.js');
var dialogContent_vue_vue_type_script_setup_true_lang = require('./dialogContent.vue2.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "cacpDialog",
    inheritAttrs: false
  },
  __name: "dialog",
  props: dialog.dialogProps,
  emits: dialog.dialogEmits,
  setup(__props, { expose: __expose }) {
    const props = __props;
    const ns = elementPlus.useNamespace("dialog");
    const dialogRef = vue.ref();
    const headerRef = vue.ref();
    const dialogContentRef = vue.ref();
    const isMinus = vue.ref(false);
    const {
      visible,
      titleId,
      bodyId,
      style,
      overlayDialogStyle,
      rendered,
      zIndex,
      afterEnter,
      afterLeave,
      beforeLeave,
      handleClose,
      onModalClick,
      onOpenAutoFocus,
      onCloseAutoFocus,
      onCloseRequested,
      onFocusoutPrevented
    } = useDialog.useDialog(props, dialogRef);
    vue.provide(elementPlus.dialogInjectionKey, {
      dialogRef,
      headerRef,
      bodyId,
      ns,
      rendered,
      style
    });
    const overlayEvent = elementPlus.useSameTarget(onModalClick);
    const resetPosition = () => {
      var _a;
      (_a = dialogContentRef.value) == null ? void 0 : _a.resetPosition();
    };
    const handleMinusChange = (value) => {
      isMinus.value = value;
    };
    __expose({
      visible,
      dialogContentRef,
      resetPosition
    });
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createBlock(vue.Teleport, {
        to: _ctx.appendTo,
        disabled: _ctx.appendTo !== "body" ? false : !_ctx.appendToBody
      }, [
        vue.createVNode(vue.Transition, {
          name: "dialog-fade",
          onAfterEnter: vue.unref(afterEnter),
          onAfterLeave: vue.unref(afterLeave),
          onBeforeLeave: vue.unref(beforeLeave),
          persisted: ""
        }, {
          default: vue.withCtx(() => [
            vue.withDirectives(vue.createVNode(vue.unref(elementPlus.ElOverlay), {
              "custom-mask-event": "",
              mask: _ctx.modal && !isMinus.value,
              "overlay-class": _ctx.modalClass,
              "z-index": vue.unref(zIndex),
              style: vue.normalizeStyle({ "pointer-events": !_ctx.modal || isMinus.value ? "none" : "auto" })
            }, {
              default: vue.withCtx(() => [
                vue.createElementVNode("div", {
                  role: "dialog",
                  "aria-modal": "true",
                  "aria-label": _ctx.title || void 0,
                  "aria-labelledby": !_ctx.title ? vue.unref(titleId) : void 0,
                  "aria-describedby": vue.unref(bodyId),
                  class: vue.normalizeClass(`${vue.unref(ns).namespace.value}-overlay-dialog`),
                  style: vue.normalizeStyle([vue.unref(overlayDialogStyle), { "pointer-events": !_ctx.modal || isMinus.value ? "none" : "auto" }]),
                  onClick: vue.unref(overlayEvent).onClick,
                  onMousedown: vue.unref(overlayEvent).onMousedown,
                  onMouseup: vue.unref(overlayEvent).onMouseup
                }, [
                  vue.createVNode(vue.unref(ElFocusTrap), {
                    loop: "",
                    trapped: vue.unref(visible),
                    "focus-start-el": "container",
                    onFocusAfterTrapped: vue.unref(onOpenAutoFocus),
                    onFocusAfterReleased: vue.unref(onCloseAutoFocus),
                    onFocusoutPrevented: vue.unref(onFocusoutPrevented),
                    onReleaseRequested: vue.unref(onCloseRequested)
                  }, {
                    default: vue.withCtx(() => [
                      vue.unref(rendered) ? (vue.openBlock(), vue.createBlock(dialogContent_vue_vue_type_script_setup_true_lang.default, vue.mergeProps({
                        key: 0,
                        ref_key: "dialogContentRef",
                        ref: dialogContentRef
                      }, _ctx.$attrs, {
                        "align-center": _ctx.alignCenter,
                        "close-icon": _ctx.closeIcon,
                        draggable: _ctx.draggable,
                        resizable: _ctx.resizable,
                        overflow: _ctx.overflow,
                        fullscreen: _ctx.fullscreen,
                        center: _ctx.center,
                        "show-close": _ctx.showClose,
                        title: _ctx.title,
                        "aria-level": _ctx.headerAriaLevel,
                        onClose: vue.unref(handleClose),
                        onMinusChange: handleMinusChange
                      }), vue.createSlots({
                        header: vue.withCtx(() => [
                          !_ctx.$slots.title ? vue.renderSlot(_ctx.$slots, "header", {
                            key: 0,
                            close: vue.unref(handleClose),
                            titleId: vue.unref(titleId),
                            titleClass: vue.unref(ns).e("title")
                          }) : vue.renderSlot(_ctx.$slots, "title", { key: 1 })
                        ]),
                        default: vue.withCtx(() => [
                          vue.renderSlot(_ctx.$slots, "default")
                        ]),
                        _: 2
                        /* DYNAMIC */
                      }, [
                        _ctx.$slots.footer ? {
                          name: "footer",
                          fn: vue.withCtx(() => [
                            vue.renderSlot(_ctx.$slots, "footer")
                          ]),
                          key: "0"
                        } : void 0
                      ]), 1040, ["align-center", "close-icon", "draggable", "resizable", "overflow", "fullscreen", "center", "show-close", "title", "aria-level", "onClose"])) : vue.createCommentVNode("v-if", true)
                    ]),
                    _: 3
                    /* FORWARDED */
                  }, 8, ["trapped", "onFocusAfterTrapped", "onFocusAfterReleased", "onFocusoutPrevented", "onReleaseRequested"])
                ], 46, ["aria-label", "aria-labelledby", "aria-describedby", "onClick", "onMousedown", "onMouseup"])
              ]),
              _: 3
              /* FORWARDED */
            }, 8, ["mask", "overlay-class", "z-index", "style"]), [
              [vue.vShow, vue.unref(visible)]
            ])
          ]),
          _: 3
          /* FORWARDED */
        }, 8, ["onAfterEnter", "onAfterLeave", "onBeforeLeave"])
      ], 8, ["to", "disabled"]);
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=dialog.vue2.js.map
