'use strict';

var vue = require('vue');
require('../../../utils/index.js');
require('../../../hooks/index.js');
var elementPlus = require('element-plus');
var style = require('../../../utils/style.js');
var index = require('../../../hooks/use-namespace/index.js');

let globalTotal = 1;
function createLoadingComponent(options) {
  let afterLeaveTimer;
  const afterLeaveFlag = vue.ref(false);
  const data = vue.reactive({
    ...options,
    originalPosition: "",
    originalOverflow: "",
    visible: false
  });
  function setText(text) {
    data.text = text;
  }
  function destroySelf() {
    const target = data.parent;
    const ns = vm.ns;
    if (!target.vLoadingAddClassList) {
      let loadingNumber = target.getAttribute("loading-number");
      loadingNumber = Number.parseInt(loadingNumber) - 1;
      if (!loadingNumber) {
        style.removeClass(target, ns.bm("parent", "relative"));
        target.removeAttribute("loading-number");
      } else {
        target.setAttribute("loading-number", loadingNumber.toString());
      }
      style.removeClass(target, ns.bm("parent", "hidden"));
    }
    removeElLoadingChild();
    loadingInstance.unmount();
  }
  function removeElLoadingChild() {
    var _a, _b;
    (_b = (_a = vm.$el) == null ? void 0 : _a.parentNode) == null ? void 0 : _b.removeChild(vm.$el);
  }
  function close() {
    var _a;
    if (options.beforeClose && !options.beforeClose()) return;
    afterLeaveFlag.value = true;
    clearTimeout(afterLeaveTimer);
    afterLeaveTimer = setTimeout(handleAfterLeave, 400);
    data.visible = false;
    (_a = options.closed) == null ? void 0 : _a.call(options);
  }
  function handleAfterLeave() {
    if (!afterLeaveFlag.value) return;
    const target = data.parent;
    afterLeaveFlag.value = false;
    target.vLoadingAddClassList = void 0;
    destroySelf();
  }
  function getAnimateColor(color) {
    if (!color)
      return ["var(--el-color-primary)", "var(--el-color-primary-light-5)"];
    return color.split(";");
  }
  function createStop(offset, color, values) {
    return vue.h(
      "stop",
      {
        offset,
        "stop-color": color
      },
      [
        values ? vue.h("animate", {
          attributeName: "offset",
          values,
          dur: "3s",
          repeatCount: "indefinite"
        }) : null
      ]
    );
  }
  const elLoadingComponent = vue.defineComponent({
    name: "CacpLoading",
    setup(_, { expose }) {
      const ns = index.useNamespace("loading");
      const config = elementPlus.useGlobalConfig();
      globalTotal += 1;
      const zIndex = elementPlus.useZIndex(
        vue.computed(() => {
          var _a;
          return ((_a = config.value) == null ? void 0 : _a.zIndex) || elementPlus.defaultInitialZIndex;
        })
      );
      expose({
        ns,
        zIndex
      });
      return () => {
        const svg = data.spinner || data.svg;
        const animateColor = getAnimateColor(data.animateColor);
        const fillColor = data.fillColor || "var(--el-fill-color)";
        const offset = 0.2 / animateColor.length;
        const step = 1 / (animateColor.length - 1);
        const animate = [];
        animateColor.forEach((color, index) => {
          animate.push(
            createStop(
              `${index * offset}%`,
              color,
              `${-1 + step * index};${1 + step * index}`
            )
          );
        });
        animate.push(createStop("0.2%", animateColor[animateColor.length - 1]));
        const spinner = vue.h(
          "svg",
          {
            class: "circular",
            viewBox: data.svgViewBox ? data.svgViewBox : "0 0 1024 1024",
            ...svg ? { innerHTML: svg } : {}
          },
          [
            vue.h("path", {
              class: "path",
              d: "M481.4 577.7l-11.8 10.1-4.1 3.7c14 33.5-34 62.3-53.9 43.5 0 0-5.3 4-10.6 8.2l-7.5 6.1c0.6 5.7 1.5 14.1 5.5 17.1 38.5 28.4 116.3-10.8 102.5-68.4l-20.1-20.3zM1005 323c-42.9-59.8-87.7-12.8-117.2-35.6-10.1-7.8-11.3-27.9-11.3-34.7v-2.3l19.2-22.8s45 11.4 63.6-22.8c21.9-40.4-22.2-91.2-66.5-83.4-36.7 6.5-41.4 47.9-42 58.9l-0.1 2.6-22.9 18c-21.9 7.4-41.4-10.2-44.3-26.6-3.6-20.1 39.2-100.2-55.4-120.6-81.1-17.5-193.8-12.9-241.7-9.8l-23.1 1.7s14 16.9 31 23.3c15.6 5.9 89.1 10.2 113.4 10.8l5.3 0.1c12.4 0 16.9 5.6 18.2 8l0.5 1.1-83.3-1.7s15.3 19.7 41.9 25.4c26.6 5.7 50.7 1.4 64.5 2.4 10.6 0.7 14.5 5.8 15.8 8.1l0.5 1.1-72.4-0.7 2.7 2.2c6.6 5.2 24.2 17.8 42.3 20.6 22.9 3.6 44.3 0.7 51.7 1.4 13.1 1.3 12.9 6.8 12.6 8.2l-0.1 0.4h-67s14.5 17.1 36 22.1c21.4 5 44.4 0.2 54.7 1.4 9.1 1.1 12.5 7.2 13.6 10l0.4 1.4h-66.5s14 18.3 36.2 20.7c14.9 1.6 33.7 0 43.6 1.4 11.8 1.7 14.2 7.5 14.7 9.8l0.1 0.9-48.5-0.3c-9.5 0-16.4 0.2-15.8 0.5l3.5 1.6 7.3 3c13 5.6 26.5 14.1 27.6 47.9l-105.5 96.5c-15.3-46.2-29.5-84.1-7.5-91.5 2.9-1 6.8-1.1 11-0.9l9.1 0.4c13.2 0.3 24.4-2.4 12.4-30.1-17.7-33.5-54.7-35.6-69.5-30.6-49.4 16.7-38 70.7-19.9 128.8l13.7 43c2.3 7.2 4.4 14.4 6.4 21.4l-87.2 79.5-89.5-88.4-98.2-97.3c-32.3-32.1-63-62.6-90.2-89.8L176 160.6c-16.1-16.3-29.1-29.5-37.8-38.6l-6.2-6.5c-38.4-39.9-91.6 15.2-59.1 48.4l6.1 6.4-79 72.4 53.2 53.2 50.2-44.6 43.4 43.7-49.3 46.5 47.3 48.4 46.3-43.7 45.3 45.6-47.3 45.6 46.3 46.5L315 408l137.7 138-71.7 65.2c-4.1-52.4 31.9-63.8 59.5-65.4l5.2-0.2h4l-27.3-27.1c-43.2-1.1-99.2 43.5-74 115.5l1.7 5.2C224.5 753 111.6 854.5 86.1 874.7l-5.7 4.3c-21.9 16.7-5.8 24.9 12.3 11.5l263.8-214.1c-0.4 42.9-34.5 55-59.7 51.6l-22.5 17.8c64.1 37.4 137-22.4 115.1-96.1l80.2-65.2 12-9.5 66.7 66.9 30.6 30.8c21 21.2 35 35.4 39.1 39.8l9.6 10.8c10.7 12.5 21.8 30.6 10.9 65-9.7 30.5-29.7 60.9-10.3 110.4 28.1 72 123.4 91 167.7 82.6 151.5-28.5 176.4-183.6 140.9-249.1s-117.2-102.1-170-61.3l-3.8 2.8c-42.6 29.2-79.1-9.4-83.1-13.8l-137-135.2 64.4-52.3c-1.3 29.5-16.5 50.2-60.4 53.3 4.7 4.2 12.3 11.5 19.5 18.6l20 20.1c76-18.6 84.2-71.1 74-126l-1.6-7.9c75.2-60.9 128.9-104.1 135-108.1l0.6-0.3c42.6-0.4 51.7 29.1 53.5 38.6l0.4 2.8 2-52.1s6.9 2.8 9.9 10c3 7.1-4.9 27.1-2 44.6 2.4 14.1 12.6 22.9 16.6 25.9l1.6 1.1 2-61.3s5.4 0.5 8.4 7.1-4.9 47-2.5 58.9c1.8 8.7 10.8 20.5 15.4 26.1l2.8 3.3 2.5-69.3s7.4 1.4 8.9 11.4c1.9 12.5-6.4 52.7-4.9 68.9 1.1 11.7 13.7 27.8 20.6 35.8l4.5 5L938 399s3.9-1 8.4 7.1c4.8 8.8-5.4 67.5-2 84.5 2.5 12.3 14.5 27.4 21 34.8l4.2 4.6 1-98.3s4.9 0.9 8.9 9.5c3.9 8.5-4.9 114.9-1 133 3.1 14 18.3 31.3 24.9 38.3l3.1 3.2c0 0.1 40.4-234.2-1.5-292.7zM721.2 822.4l5-1.4c50.1-14.2 45.2-34.2 56.3-72 15.5-52.7 107.2-37.5 111.6 39.9 3.7 65.5-39.2 139.6-137.4 134.6l-4-0.2c-69.5-4.2-96.2-84.3-31.5-100.9zM273 705.9c-1.1-43.1 36.2-57.7 51.7-46.3l21.4-19.2c-2.9-5.3-1.6-16.1-8.3-18.6-33.7-12.9-110 18.8-87.4 104.1 7.3-6 13.3-11.4 17.3-15l5.3-5z m300.7-275.1l2.2 1s10.4-10 16.1-15l2.6-2.1C584.3 350.6 478.5 378.6 477 457l31 31c18.5-70.3 56.1-60.9 65.7-57.2z m267.2 14c-0.6-15.4-10.5-25.3-26-37l-7.5-5.5c-24.6-18-35.2 1.2-32.5 13.3l0.6 3.4c6.3 44.2-73 24.1-102.3 15.2l-10.7-3.4s6.9 38.7 3.9 49.6c45 11.4 177.9 44.9 174.5-35.6z",
              fill: `url(#gradient-${globalTotal})`
            }),
            vue.h(
              "defs",
              vue.h("linearGradient", { id: `gradient-${globalTotal}` }, [
                vue.h("animateTransform", {
                  attributeName: "gradientTransform",
                  type: "rotate",
                  from: "135 1 0",
                  to: "135  0 1",
                  dur: "3s",
                  repeatCount: "indefinite"
                }),
                ...animate,
                createStop("0.2%", fillColor),
                createStop("100%", fillColor)
              ])
            )
          ]
        );
        const spinnerText = data.text ? vue.h("p", { class: ns.b("text") }, [data.text]) : void 0;
        return vue.h(
          vue.Transition,
          {
            name: ns.b("fade"),
            onAfterLeave: handleAfterLeave
          },
          {
            default: vue.withCtx(() => [
              vue.withDirectives(
                vue.createVNode(
                  "div",
                  {
                    style: {
                      backgroundColor: data.background || ""
                    },
                    class: [
                      ns.b("mask"),
                      data.customClass,
                      data.fullscreen ? "is-fullscreen" : ""
                    ]
                  },
                  [
                    vue.h(
                      "div",
                      {
                        class: ns.b("spinner")
                      },
                      [spinner, spinnerText]
                    )
                  ]
                ),
                [[vue.vShow, data.visible]]
              )
            ])
          }
        );
      };
    }
  });
  const loadingInstance = vue.createApp(elLoadingComponent);
  const vm = loadingInstance.mount(document.createElement("div"));
  return {
    ...vue.toRefs(data),
    setText,
    removeElLoadingChild,
    close,
    handleAfterLeave,
    vm,
    get $el() {
      return vm.$el;
    }
  };
}

exports.createLoadingComponent = createLoadingComponent;
//# sourceMappingURL=loading.js.map
