'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var index$1 = require('../../../../svg-icons/vue/dist/index.js');
require('../../../hooks/index.js');
var lodashEs = require('lodash-es');
var index = require('../../../hooks/use-namespace/index.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpStickyToolbar"
  },
  __name: "stickyToolbar",
  props: {
    selector: { type: String, required: false, default: ".el-button" }
  },
  emits: ["toggleEnd"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const bem = index.useNamespace("sticky");
    const props = __props;
    const wrapperDom = vue.ref(null);
    const elDom = vue.ref(null);
    const minHeight = vue.ref(0);
    const maxHeight = vue.ref(0);
    const showToggle = vue.ref(false);
    const collapse = vue.ref(true);
    let marginBottom = 10;
    let enableEmit = false;
    const init = async () => {
      enableEmit = false;
      if (wrapperDom.value) {
        elDom.value = wrapperDom.value.querySelector(props.selector);
        if (elDom.value != null) {
          if (getComputedStyle(elDom.value).display === "none") {
            elDom.value.style.display = "";
          }
          minHeight.value = elDom.value.offsetHeight;
          marginBottom = parseInt(getComputedStyle(elDom.value).marginBottom);
        }
        maxHeight.value = wrapperDom.value.scrollHeight - marginBottom;
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
        setTimeout(() => {
          wrapperDom.value.style.transition = "max-height linear 0.3s";
        }, 0);
      }
    };
    const resize = () => {
      enableEmit = false;
      if (elDom.value && elDom.value.offsetHeight > 0) {
        minHeight.value = elDom.value.offsetHeight;
        marginBottom = parseInt(getComputedStyle(elDom.value).marginBottom);
        maxHeight.value = wrapperDom.value.scrollHeight - marginBottom;
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const modeChangeResize = () => {
      var _a;
      (_a = wrapperDom.value) == null ? void 0 : _a.addEventListener("transitionend", resize, { once: true });
    };
    const onToggle = () => {
      enableEmit = true;
      collapse.value = !collapse.value;
      if (wrapperDom.value) {
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const emit = __emit;
    const onToggleEnd = () => {
      if (enableEmit) {
        emit("toggleEnd", collapse.value);
      }
    };
    __expose({ onToggle });
    let debounceResize = lodashEs.debounce(resize, 100);
    vue.onMounted(() => {
      init();
      window.addEventListener("resize", debounceResize);
      window.addEventListener("modeChange", modeChangeResize);
    });
    vue.onUnmounted(() => {
      window.removeEventListener("resize", debounceResize);
      window.removeEventListener("modeChange", modeChangeResize);
    });
    return (_ctx, _cache) => {
      const _component_el_button = vue.resolveComponent("el-button");
      return vue.openBlock(), vue.createElementBlock(
        "div",
        {
          class: vue.normalizeClass(vue.unref(bem).e("toolbar"))
        },
        [
          vue.createElementVNode(
            "div",
            {
              class: vue.normalizeClass(vue.unref(bem).e("main"))
            },
            [
              vue.createElementVNode(
                "div",
                {
                  class: vue.normalizeClass(vue.unref(bem).e("wrap")),
                  ref_key: "wrapperDom",
                  ref: wrapperDom,
                  onTransitionend: vue.withModifiers(onToggleEnd, ["self"])
                },
                [
                  vue.renderSlot(_ctx.$slots, "content")
                ],
                34
                /* CLASS, NEED_HYDRATION */
              ),
              showToggle.value ? vue.renderSlot(_ctx.$slots, "toggle", { key: 0 }, () => [
                vue.createVNode(_component_el_button, {
                  type: "primary",
                  icon: collapse.value ? vue.unref(index$1.ArrowDown) : vue.unref(index$1.ArrowUp),
                  onClick: onToggle,
                  class: vue.normalizeClass(vue.unref(bem).e("toggle"))
                }, null, 8, ["icon", "class"])
              ]) : vue.createCommentVNode("v-if", true)
            ],
            2
            /* CLASS */
          ),
          vue.renderSlot(_ctx.$slots, "side")
        ],
        2
        /* CLASS */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=stickyToolbar.vue2.js.map
