export type OguType = 'USER' | 'ORGANIZATION';
export interface CacpRole {
    appCode: string;
    code: string;
    name: string;
    resourceLevel: string;
}
export interface CacpPermission {
    appCode: string;
    code: string;
    name: string;
}
export interface BaseCacpOgu {
    oguId: string;
    oguName: string;
    parentId: string;
    fullPathName: string;
    sortOrder: string;
    oguType: OguType;
}
export interface CacpUser extends BaseCacpOgu {
    personId: string;
    customsCode: string;
    email: string;
    mobile: string;
    status: string;
    oguType: 'USER';
    roles: Array<CacpRole>;
    authorities: Array<CacpPermission>;
}
export interface CacpOrganization extends BaseCacpOgu {
    branch: boolean;
    oguType: 'ORGANIZATION';
}
export interface UserAuthorityInfo {
    roles: Array<CacpRole>;
    permissions: Array<CacpPermission>;
}
