import type { Accessory } from './accessory';
import type { OguType } from '../framework/auth';
export type AssignmentDescriptorType = 'NONE' | 'ISSUER' | 'BRANCH_CREATOR' | 'USER' | 'DEPT' | 'ROLE_DEPT' | 'ROLE_LEVEL' | 'ROLE' | 'EXTEND';
export type DeptHandleType = 'NONE' | 'ZHUBAN' | 'XIEBAN' | 'HUIQIAN' | 'ZHUSONG' | 'CHAOSONG';
export type FlowDescriptorType = 'NORMAL' | 'CONDITION';
export type OperateStatus = 'NONE' | 'AGREE' | 'REJECT' | 'BACK' | 'REVOKE';
export type ProcessRuntimeStatus = 'NONE' | 'RUNNING' | 'SUSPENDING' | 'COMPLETED';
export type TaskType = 'WAITING_TASK' | 'WAITING_TASK' | 'COMPLETED_TASK' | 'SUSPENDING_TASK';
export type FormRuntimeStatus = 'NOSTART' | 'RUNNING' | 'REJECTED' | 'COMPLETED' | 'ABORTED';
export type NodeDescriptorType = 'START' | 'END' | 'APPROVE' | 'BRANCH' | 'VIRTUAL' | 'COPY';
export type CompleteStrategy = 'ONE' | 'ALL' | 'BRANCH' | 'PERCENT' | 'COUNT';
export type OperMode = 'create' | 'oper' | 'show';
export type OperationType = 'save' | 'delete' | 'suspend' | 'back' | 'reject' | 'agree' | 'revoke';
export declare function getOperationType(type: OperationType): string;
export interface CommentTemplate {
    commentId: string;
    commentName: string;
    commentTemplate: string;
    appCode: string;
    processCode: string;
    activityCode: string;
}
export interface ProcessDefinition {
    appCode: string;
    code: string;
    name: string;
    version: number;
    content: string;
    branch: boolean;
    enabled: boolean;
    expireDays: number;
    description?: string;
}
export interface ProcessDescriptor {
    code: string;
    name: string;
    branch: boolean;
    expireDays: number;
    description?: string;
    nodes: Array<NodeDescriptor>;
    flows: Array<FlowDescriptor>;
}
export interface NodeDescriptor {
    type: NodeDescriptorType;
    code: string;
    name: string;
    description?: string;
    backCode?: string;
    branchCode?: string;
    seceneCode?: string;
    routeOptional?: boolean;
    completeStrategy?: CompleteStrategyDescriptor;
    expireDays?: number;
    keepTrace?: boolean;
    returnable?: boolean;
    assignment?: AssignmentDescriptor;
    options: Record<string, unknown>;
    attrs: Record<string, unknown>;
    listeners: Array<string>;
}
export interface FlowDescriptor {
    type: FlowDescriptorType;
    code: string;
    name: string;
    source: string;
    target: string;
    condition?: string;
}
export interface AssignmentDescriptor {
    type: AssignmentDescriptorType;
    branchDepts?: string;
    roleCode?: string;
    userPaths?: string;
    deptPaths?: string;
    deptLevel?: number;
    className?: string;
    extendParam?: string;
    [key: string]: string | number | boolean | undefined;
}
export interface CompleteStrategyDescriptor {
    strategy: CompleteStrategy;
    value?: number;
}
export interface BaseWorkflowForm {
    formId: string;
    appCode: string;
    formTitle: string;
    formStatus: FormRuntimeStatus;
    exists: boolean;
    processId: string;
    processCode: string;
    processRange: number;
    issueUserId: string;
    issueUserName: string;
    issueUserParentId: string;
    issueUserFullPathName: string;
    issueDeptFullPathName: string;
    createTime: string;
    completeTime?: string;
}
export interface RuntimeProcess {
    processId: string;
    appCode: string;
    processCode: string;
    processVersion: number;
    processRange: number;
    parentProcessId?: string;
    parentActivityId?: string;
    parentAssignmentId: string;
    bizId: string;
    bizTitle?: string;
    bizUrlFormat: string;
    bizSaved: boolean;
    issueUserId: string;
    issueUserName: string;
    issueUserParentId: string;
    issueUserFullPath: string;
    runtimeStatus: ProcessRuntimeStatus;
    createTime: string;
    expireTime: string;
    completeTime?: string;
    activities: Array<RuntimeActivity>;
}
export interface RuntimeActivity {
    activityId: string;
    processId: string;
    nodeType: NodeDescriptorType;
    nodeCode: string;
    nodeName: string;
    runtimeStatus: ProcessRuntimeStatus;
    operateStatus: OperateStatus;
    createTime: string;
    expireTime: string;
    startTime?: string;
    completeTime?: string;
    prevUserId?: string;
    prevUserName?: string;
    prevUserParentId?: string;
    prevUserFullPath?: string;
    prevActivityId?: string;
    prevActivityCode?: string;
    prevActivityType?: NodeDescriptorType;
    assignments: Array<RuntimeAssignment>;
}
export interface RuntimeAssignment {
    assignId: string;
    processId: string;
    activityId: string;
    receiverId: string;
    receiverName: string;
    receiverParentId: string;
    receiverFullPath: string;
    receiverType: OguType;
    receiverHandleType: DeptHandleType;
    operated: boolean;
    operateStatus: OperateStatus;
    createTime: string;
    readTime?: string;
    operateTime?: string;
}
export interface RuntimeComment {
    assignId: string;
    appCode: string;
    bizId: string;
    processId: string;
    activityId: string;
    comments: string;
    accessoryList: Array<Accessory>;
}
export interface RuntimeRouteNode {
    code: string;
    name: string;
    description?: string;
    options: Record<string, unknown>;
    assigns: Array<RuntimeOgu>;
}
export interface RuntimeTask {
    taskId: string;
    viewCode: string;
    appCode: string;
    bizId: string;
    taskTitle?: string;
    senderId: string;
    senderParentId: string;
    senderName: string;
    senderFullPath: string;
    receiverId: string;
    receiverParentId: string;
    receiverName: string;
    receiverFullPath: string;
    copyFlag: boolean;
    keepTrace: boolean;
    delegateFlag: boolean;
    delegateUserId?: string;
    delegateUserName?: string;
    delegateParentId?: string;
    delegateFullPath?: string;
    url: string;
    taskDesc?: string;
    taskType: TaskType;
    createTime: string;
    expireTime: string;
    startTime?: string;
    completeTime?: string;
    processId: string;
    activityId: string;
    assignId: string;
}
export interface RuntimeOgu {
    oguId: string;
    oguName: string;
    oguType: OguType;
    parentId: string;
    fullPathName: string;
    copyFlag: boolean;
    deptType: DeptHandleType;
    delegateFlag: boolean;
    delegateUserId?: string;
    delegateUserName?: string;
    delegateParentId?: string;
    delegateFullPath?: string;
}
export interface NodeDescriptorDto {
    code: string;
    name: string;
    type: NodeDescriptorType;
    routeOptional: boolean;
    options: Record<string, unknown>;
}
export interface CommentsDto {
    userModified: boolean;
    userComments: string;
    userAccessoryList: Array<Accessory>;
    deptModified: boolean;
    deptComments: string;
    deptAccessoryList: Array<Accessory>;
}
export interface AgreeAutoRequestDto<T extends BaseWorkflowForm> {
    taskId: string;
    comments?: CommentsDto;
    copyNodeCode: string;
    copyOguList: Array<RuntimeOgu>;
    nextBranchList: Array<RuntimeOgu>;
    variables?: Record<string, unknown>;
    form: T;
}
export interface AgreeRequestDto<T extends BaseWorkflowForm> {
    taskId: string;
    comments?: CommentsDto;
    routeNodeCode: string;
    routeOguList: Array<RuntimeOgu>;
    copyNodeCode: string;
    copyOguList: Array<RuntimeOgu>;
    variables?: Record<string, unknown>;
    form: T;
}
export interface CreateRequestDto {
    urlFormat: string;
    processCode: string;
    range: number;
    variables?: Record<string, unknown>;
}
export interface OperateRequestDto<T extends BaseWorkflowForm> {
    taskId: string;
    comments?: CommentsDto;
    form: T;
}
export interface RouteRequestDto {
    taskId: string;
    variables?: Record<string, unknown>;
}
export interface SaveRequestDto<T extends BaseWorkflowForm> {
    taskId: string;
    comments?: CommentsDto;
    form: T;
}
export interface AdjustRequestDto {
    processId: string;
    toProcessCode?: string;
    toNodeCode: string;
    toOgu: RuntimeOgu;
}
export interface StartResponseDto<T extends BaseWorkflowForm> {
    task: TaskDto;
    comments: CommentsDto;
    processCode: string;
    activityDescriptor: NodeDescriptorDto;
    canApprove: boolean;
    canOperate: Record<string, boolean>;
    canCopy: boolean;
    copyNodeCode: string;
    copyAssigns: Array<RuntimeOgu>;
    form: T;
}
export interface TaskDto {
    taskId: string;
    viewCode: string;
    appCode: string;
    bizId: string;
    taskTitle: string;
    senderId: string;
    senderParentId: string;
    senderName: string;
    senderFullPath: string;
    receiverId: string;
    receiverParentId: string;
    receiverName: string;
    receiverFullPath: string;
    copyFlag: boolean;
    keepTrace: boolean;
    delegateFlag: boolean;
    delegateUserId: string;
    delegateUserName: string;
    delegateParentId: string;
    delegateFullPath: string;
    url: string;
    taskDesc: string;
    taskType: TaskType;
    createTime: string;
    expireTime: string;
    startTime: string;
    completeTime: string;
    processId: string;
    activityId: string;
    assignId: string;
    operated: boolean;
    operateStatus: OperateStatus;
    readTime: string;
    operateTime: string;
}
export interface NextRouteData {
    nextNodeCode: string;
    nextOguList: Array<RuntimeOgu>;
}
export interface TraceInfo {
    processId: string;
    createTime: string;
    completeTime: string;
    activities: Array<TraceActivityInfo>;
}
export interface TraceActivityInfo {
    activityId: string;
    processId: string;
    nodeType: NodeDescriptorType;
    nodeCode: string;
    nodeName: string;
    runtimeStatus: ProcessRuntimeStatus;
    operateStatus: OperateStatus;
    createTime: string;
    startTime: string;
    completeTime: string;
    prevUserId: string;
    prevUserName: string;
    prevUserParentId: string;
    prevUserFullPath: string;
    prevActivityId: string;
    prevActivityCode: string;
    prevActivityType: NodeDescriptorType;
    assignments: Array<TraceAssignInfo>;
}
export interface TraceAssignInfo {
    assignId: string;
    processId: string;
    activityId: string;
    receiverId: string;
    receiverName: string;
    receiverParentId: string;
    receiverFullPath: string;
    receiverType: OguType;
    receiverHandleType: DeptHandleType;
    operated: boolean;
    operateStatus: OperateStatus;
    createTime: string;
    readTime: string;
    operateTime: string;
    comments: string;
    accessoryList: Array<Accessory>;
}
