import { defineComponent, inject, computed, openBlock, createElementBlock, unref, normalizeClass, normalizeStyle, createElementVNode, renderSlot, toDisplayString, Fragment, createVNode, withCtx, createCommentVNode, createBlock, resolveDynamicComponent } from 'vue';
import { composeRefs } from 'element-plus/es/utils/index';
import { dialogInjectionKey, ElIcon } from 'element-plus';
import { FOCUS_TRAP_INJECTION_KEY } from 'element-plus/es/components/focus-trap/index';
import { Minus as minus_default, FullScreen as full_screen_default, CopyDocument as copy_document_default, Close as close_default } from '../../../../svg-icons/vue/dist/index.mjs';
import { dialogContentProps } from './dialog-content.mjs';
import '../../../hooks/index.mjs';
import { useDraggableAndResizable } from '../../../hooks/use-draggable-resize/index.mjs';

var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "CacpDialogContent"
  },
  __name: "dialogContent",
  props: dialogContentProps,
  emits: ["close", "minusChange"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const { dialogRef, headerRef, bodyId, ns, style } = inject(dialogInjectionKey);
    const { focusTrapRef } = inject(FOCUS_TRAP_INJECTION_KEY);
    const composeDialogRef = composeRefs(focusTrapRef, dialogRef);
    const draggable = computed(() => props.draggable);
    const overflow = computed(() => props.overflow);
    const isFullscreen = computed(() => props.fullscreen);
    const resizable = computed(() => props.resizable);
    const alignCenter = computed(() => props.alignCenter);
    const { resetPosition, resetSize, onExpand, onCompress, onMinus, fullscreen, minus } = useDraggableAndResizable(
      dialogRef,
      headerRef,
      draggable,
      resizable,
      isFullscreen,
      alignCenter,
      overflow
    );
    const dialogKls = computed(() => [
      ns.b(),
      ns.is("fullscreen", fullscreen.value),
      ns.is("minus", minus.value),
      ns.is("draggable", props.draggable),
      ns.is("resizable", props.resizable),
      ns.is("align-center", props.alignCenter),
      { [ns.m("center")]: props.center }
    ]);
    const onClose = () => {
      emit("close");
    };
    const _onMinus = () => {
      onMinus();
      emit("minusChange", minus.value);
    };
    const _onCompress = () => {
      onCompress();
      emit("minusChange", minus.value);
    };
    __expose({
      resetPosition,
      resetSize
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          ref: unref(composeDialogRef),
          class: normalizeClass(dialogKls.value),
          style: normalizeStyle(unref(style)),
          tabindex: "-1"
        },
        [
          createElementVNode(
            "header",
            {
              ref_key: "headerRef",
              ref: headerRef,
              class: normalizeClass([unref(ns).e("header"), { "show-close": _ctx.showClose }])
            },
            [
              renderSlot(_ctx.$slots, "header", {}, () => [
                createElementVNode("span", {
                  role: "heading",
                  "aria-level": _ctx.ariaLevel,
                  class: normalizeClass(unref(ns).e("title"))
                }, toDisplayString(_ctx.title), 11, ["aria-level"])
              ]),
              createElementVNode(
                "div",
                {
                  class: normalizeClass(unref(ns).e("headerbtns"))
                },
                [
                  resizable.value ? (openBlock(), createElementBlock(
                    Fragment,
                    { key: 0 },
                    [
                      !unref(minus) ? (openBlock(), createElementBlock(
                        "button",
                        {
                          key: 0,
                          "aria-label": "\u6700\u5C0F\u5316",
                          class: normalizeClass(unref(ns).e("headerbtn")),
                          type: "button",
                          onClick: _onMinus
                        },
                        [
                          createVNode(unref(ElIcon), {
                            class: normalizeClass(unref(ns).e("close")),
                            size: 18
                          }, {
                            default: withCtx(() => [
                              createVNode(unref(minus_default))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class"])
                        ],
                        2
                        /* CLASS */
                      )) : createCommentVNode("v-if", true),
                      !unref(fullscreen) && !unref(minus) ? (openBlock(), createElementBlock("button", {
                        key: 1,
                        "aria-label": "\u6700\u5927\u5316",
                        class: normalizeClass(unref(ns).e("headerbtn")),
                        type: "button",
                        onClick: unref(onExpand)
                      }, [
                        createVNode(unref(ElIcon), {
                          class: normalizeClass(unref(ns).e("close")),
                          size: 18
                        }, {
                          default: withCtx(() => [
                            createVNode(unref(full_screen_default))
                          ]),
                          _: 1
                          /* STABLE */
                        }, 8, ["class"])
                      ], 10, ["onClick"])) : (openBlock(), createElementBlock(
                        "button",
                        {
                          key: 2,
                          "aria-label": "\u8FD8\u539F",
                          class: normalizeClass(unref(ns).e("headerbtn")),
                          type: "button",
                          onClick: _onCompress
                        },
                        [
                          createVNode(unref(ElIcon), {
                            class: normalizeClass(unref(ns).e("close")),
                            size: 18
                          }, {
                            default: withCtx(() => [
                              createVNode(unref(copy_document_default))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class"])
                        ],
                        2
                        /* CLASS */
                      ))
                    ],
                    64
                    /* STABLE_FRAGMENT */
                  )) : createCommentVNode("v-if", true),
                  _ctx.showClose ? (openBlock(), createElementBlock(
                    "button",
                    {
                      key: 1,
                      "aria-label": "\u5173\u95ED",
                      class: normalizeClass(unref(ns).e("headerbtn")),
                      type: "button",
                      onClick: onClose
                    },
                    [
                      createVNode(unref(ElIcon), {
                        class: normalizeClass(unref(ns).e("close"))
                      }, {
                        default: withCtx(() => [
                          (openBlock(), createBlock(resolveDynamicComponent(_ctx.closeIcon || unref(close_default))))
                        ]),
                        _: 1
                        /* STABLE */
                      }, 8, ["class"])
                    ],
                    2
                    /* CLASS */
                  )) : createCommentVNode("v-if", true)
                ],
                2
                /* CLASS */
              )
            ],
            2
            /* CLASS */
          ),
          createElementVNode("div", {
            id: unref(bodyId),
            class: normalizeClass(unref(ns).e("body"))
          }, [
            renderSlot(_ctx.$slots, "default")
          ], 10, ["id"]),
          _ctx.$slots.footer ? (openBlock(), createElementBlock(
            "footer",
            {
              key: 0,
              class: normalizeClass(unref(ns).e("footer"))
            },
            [
              renderSlot(_ctx.$slots, "footer")
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true)
        ],
        6
        /* CLASS, STYLE */
      );
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=dialogContent.vue2.mjs.map
