import { NOOP } from '@vue/shared';
import { buildProps, definePropType, isArray, isString, isObject, isBoolean } from 'element-plus/es/utils/index';
import { useTooltipContentProps } from 'element-plus/es/components/tooltip/index';
import { useAriaProps } from 'element-plus/es/hooks/index';
import '../../../constants/index.mjs';
import { UPDATE_MODEL_EVENT, INPUT_EVENT, CHANGE_EVENT } from '../../../constants/event.mjs';

const autocompleteProps = buildProps({
  // 用来展示的字段名
  valueKey: {
    type: String,
    default: "value"
  },
  // 选中项绑定值
  modelValue: {
    type: Array,
    default: []
  },
  // 获取输入建议的防抖延时，单位为毫秒
  debounce: {
    type: Number,
    default: 300
  },
  // 下拉框出现的位置
  placement: {
    type: definePropType(String),
    values: [
      "top",
      "top-start",
      "top-end",
      "bottom",
      "bottom-start",
      "bottom-end"
    ],
    default: "bottom-start"
  },
  // 获取输入建议的方法，仅当输入的建议数据resolve的时候，通过调用callback(data:[])来返回它
  fetchSuggestions: {
    type: definePropType([Function, Array]),
    default: NOOP
  },
  // 远程搜索中的返回值允许点击几个
  multiple: {
    type: Boolean,
    default: false
  },
  popperClass: {
    type: String,
    default: ""
  },
  triggerOnFocus: {
    type: Boolean,
    default: true
  },
  selectWhenUnmatched: {
    type: Boolean,
    default: false
  },
  hideLoading: {
    type: Boolean,
    default: false
  },
  teleported: useTooltipContentProps.teleported,
  highlightFirstItem: {
    type: Boolean,
    default: false
  },
  fitInputWidth: {
    type: Boolean,
    default: false
  },
  clearable: {
    type: Boolean,
    default: false
  },
  name: String,
  ...useAriaProps(["ariaLabel"])
});
const autocompleteEmits = {
  [UPDATE_MODEL_EVENT]: (value) => isArray(value),
  [INPUT_EVENT]: (value) => isString(value),
  [CHANGE_EVENT]: (value) => isString(value),
  focus: (evt) => evt instanceof FocusEvent,
  blur: (evt) => evt instanceof FocusEvent,
  clear: () => true,
  select: (item, selected) => isObject(item) && isBoolean(selected)
};

export { autocompleteEmits, autocompleteProps };
//# sourceMappingURL=autocomplete.mjs.map
