import { BridgeMessage, MessageType, SourceType, ContextType, PostMessageFn } from '../types/protocol';
type MessageHandler<T = any> = (payload: T) => void;
export declare class BridgeCore {
    private modules;
    private allowedOrigins;
    private secretKey?;
    private communicator;
    private iframeContext?;
    private tabContext?;
    private source;
    private strict;
    constructor(config: {
        allowedOrigins: string[];
        secretKey?: string;
        iframeContext?: HTMLIFrameElement[];
        tabContext?: Map<string, PostMessageFn>;
        source: SourceType;
        strict?: boolean;
    });
    private initListener;
    private handleMessage;
    private parseMessage;
    private routeMessage;
    private validateOrigin;
    private handleError;
    registerHandler<T>(type: MessageType, handler: MessageHandler<T>): void;
    send<T>(type: string, payload: T, target?: string): void;
    destroy(): void;
    verifyMessageSignature(message: BridgeMessage, signature: string): boolean;
    generateMessageNonce(): string;
    addAllowedOrigin(origin: string): void;
    clearAllowedOrigins(): void;
    updateContext(context: HTMLIFrameElement[] | Map<string, PostMessageFn>, type: ContextType): void;
}
export {};
