'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var lodashEs = require('lodash-es');
var index$1 = require('../../../../svg-icons/vue/dist/index.js');
require('../../../hooks/index.js');
var index = require('../../../hooks/use-namespace/index.js');

var _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...{
    name: "CacpCollapsePanel"
  },
  __name: "collapsePanel",
  props: {
    collapse: { type: Boolean, required: false, default: true },
    selector: { type: String, required: false, default: ".el-col" }
  },
  emits: ["toggleEnd"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const bem = index.useNamespace("collapse");
    const props = __props;
    const collapse = vue.ref(props.collapse);
    const minHeight = vue.ref(0);
    const maxHeight = vue.ref(0);
    const collapseSelector = vue.ref(props.selector);
    const collapseDom = vue.ref(null);
    const wrapperDom = vue.ref(null);
    const showToggle = vue.ref(false);
    let enableEmit = false;
    let needUpdate = true;
    let resizeObsever;
    const init = async () => {
      var _a;
      collapseDom.value = (_a = wrapperDom.value) == null ? void 0 : _a.querySelector(collapseSelector.value);
      if (collapseDom.value) {
        if (getComputedStyle(collapseDom.value).display === "none") {
          collapseDom.value.style.display = "";
        }
        minHeight.value = collapseDom.value.offsetHeight;
        maxHeight.value = wrapperDom.value.scrollHeight;
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
        await vue.nextTick();
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.transition = "max-height linear 0.3s";
      }
    };
    const resize = () => {
      enableEmit = false;
      if (collapseDom.value && collapseDom.value.offsetHeight > 0) {
        minHeight.value = collapseDom.value.offsetHeight;
        maxHeight.value = wrapperDom.value.scrollHeight;
        if (minHeight.value == maxHeight.value) {
          showToggle.value = false;
        } else {
          showToggle.value = true;
        }
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const modeChangeResize = () => {
      var _a;
      (_a = wrapperDom.value) == null ? void 0 : _a.addEventListener("transitionend", resize, { once: true });
    };
    const onToggle = () => {
      enableEmit = true;
      needUpdate = false;
      collapse.value = !collapse.value;
      if (wrapperDom.value) {
        wrapperDom.value.style.maxHeight = collapse.value ? `${minHeight.value}px` : `${maxHeight.value}px`;
      }
    };
    const emit = __emit;
    const onToggleEnd = () => {
      if (enableEmit) {
        emit("toggleEnd", collapse.value);
      }
    };
    __expose({ onToggle });
    let debounceResize = lodashEs.debounce(resize, 100);
    vue.onMounted(() => {
      init();
      window.addEventListener("resize", debounceResize);
      window.addEventListener("modeChange", modeChangeResize);
      if ((wrapperDom == null ? void 0 : wrapperDom.value) && ResizeObserver) {
        resizeObsever = new ResizeObserver(debounceResize);
        resizeObsever.observe(wrapperDom == null ? void 0 : wrapperDom.value);
      }
    });
    vue.onUnmounted(() => {
      window.removeEventListener("resize", debounceResize);
      window.removeEventListener("modeChange", modeChangeResize);
      resizeObsever == null ? void 0 : resizeObsever.disconnect();
    });
    vue.onUpdated(() => {
      if (needUpdate) {
        resize();
        needUpdate = false;
      }
      vue.nextTick(() => {
        needUpdate = true;
      });
    });
    return (_ctx, _cache) => {
      const _component_el_link = vue.resolveComponent("el-link");
      return vue.openBlock(), vue.createElementBlock(
        vue.Fragment,
        null,
        [
          vue.createElementVNode(
            "div",
            {
              class: vue.normalizeClass(vue.unref(bem).m("panel")),
              ref_key: "wrapperDom",
              ref: wrapperDom,
              onTransitionend: vue.withModifiers(onToggleEnd, ["self"])
            },
            [
              vue.renderSlot(_ctx.$slots, "content")
            ],
            34
            /* CLASS, NEED_HYDRATION */
          ),
          vue.createElementVNode(
            "div",
            {
              class: vue.normalizeClass(vue.unref(bem).m("footer"))
            },
            [
              vue.renderSlot(_ctx.$slots, "footer"),
              showToggle.value ? vue.renderSlot(_ctx.$slots, "toggle", {
                key: 0,
                collapsed: collapse.value,
                onToggle
              }, () => [
                vue.createVNode(_component_el_link, {
                  onClick: onToggle,
                  type: "primary",
                  underline: false,
                  icon: vue.unref(index$1.Filter),
                  class: vue.normalizeClass(vue.unref(bem).e("toggle"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createTextVNode("\u9AD8\u7EA7\u67E5\u8BE2")
                  ]),
                  _: 1
                  /* STABLE */
                }, 8, ["icon", "class"])
              ]) : vue.createCommentVNode("v-if", true)
            ],
            2
            /* CLASS */
          )
        ],
        64
        /* STABLE_FRAGMENT */
      );
    };
  }
});

exports.default = _sfc_main;
//# sourceMappingURL=collapsePanel.vue2.js.map
